@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.TrafficMirrorFilterRuleArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.TrafficMirrorFilterRuleDestinationPortRangeArgs
import com.pulumi.aws.ec2.kotlin.inputs.TrafficMirrorFilterRuleDestinationPortRangeArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.TrafficMirrorFilterRuleSourcePortRangeArgs
import com.pulumi.aws.ec2.kotlin.inputs.TrafficMirrorFilterRuleSourcePortRangeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an Traffic mirror filter rule.
 * Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring
 * ## Example Usage
 * To create a basic traffic mirror session
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.TrafficMirrorFilter;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterArgs;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterRule;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterRuleArgs;
 * import com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleDestinationPortRangeArgs;
 * import com.pulumi.aws.ec2.inputs.TrafficMirrorFilterRuleSourcePortRangeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var filter = new TrafficMirrorFilter("filter", TrafficMirrorFilterArgs.builder()
 *             .description("traffic mirror filter - example")
 *             .networkServices("amazon-dns")
 *             .build());
 *         var ruleout = new TrafficMirrorFilterRule("ruleout", TrafficMirrorFilterRuleArgs.builder()
 *             .description("test rule")
 *             .trafficMirrorFilterId(filter.id())
 *             .destinationCidrBlock("10.0.0.0/8")
 *             .sourceCidrBlock("10.0.0.0/8")
 *             .ruleNumber(1)
 *             .ruleAction("accept")
 *             .trafficDirection("egress")
 *             .build());
 *         var rulein = new TrafficMirrorFilterRule("rulein", TrafficMirrorFilterRuleArgs.builder()
 *             .description("test rule")
 *             .trafficMirrorFilterId(filter.id())
 *             .destinationCidrBlock("10.0.0.0/8")
 *             .sourceCidrBlock("10.0.0.0/8")
 *             .ruleNumber(1)
 *             .ruleAction("accept")
 *             .trafficDirection("ingress")
 *             .protocol(6)
 *             .destinationPortRange(TrafficMirrorFilterRuleDestinationPortRangeArgs.builder()
 *                 .fromPort(22)
 *                 .toPort(53)
 *                 .build())
 *             .sourcePortRange(TrafficMirrorFilterRuleSourcePortRangeArgs.builder()
 *                 .fromPort(0)
 *                 .toPort(10)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import traffic mirror rules using the `traffic_mirror_filter_id` and `id` separated by `:`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/trafficMirrorFilterRule:TrafficMirrorFilterRule rule tmf-0fbb93ddf38198f64:tmfr-05a458f06445d0aee
 * ```
 * @property description Description of the traffic mirror filter rule.
 * @property destinationCidrBlock Destination CIDR block to assign to the Traffic Mirror rule.
 * @property destinationPortRange Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
 * @property protocol Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
 * @property ruleAction Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
 * @property ruleNumber Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
 * @property sourceCidrBlock Source CIDR block to assign to the Traffic Mirror rule.
 * @property sourcePortRange Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
 * @property trafficDirection Direction of traffic to be captured. Valid values are `ingress` and `egress`
 * Traffic mirror port range support following attributes:
 * @property trafficMirrorFilterId ID of the traffic mirror filter to which this rule should be added
 */
public data class TrafficMirrorFilterRuleArgs(
    public val description: Output<String>? = null,
    public val destinationCidrBlock: Output<String>? = null,
    public val destinationPortRange: Output<TrafficMirrorFilterRuleDestinationPortRangeArgs>? = null,
    public val protocol: Output<Int>? = null,
    public val ruleAction: Output<String>? = null,
    public val ruleNumber: Output<Int>? = null,
    public val sourceCidrBlock: Output<String>? = null,
    public val sourcePortRange: Output<TrafficMirrorFilterRuleSourcePortRangeArgs>? = null,
    public val trafficDirection: Output<String>? = null,
    public val trafficMirrorFilterId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.TrafficMirrorFilterRuleArgs> {
    override fun toJava(): com.pulumi.aws.ec2.TrafficMirrorFilterRuleArgs =
        com.pulumi.aws.ec2.TrafficMirrorFilterRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationCidrBlock(destinationCidrBlock?.applyValue({ args0 -> args0 }))
            .destinationPortRange(
                destinationPortRange?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .ruleAction(ruleAction?.applyValue({ args0 -> args0 }))
            .ruleNumber(ruleNumber?.applyValue({ args0 -> args0 }))
            .sourceCidrBlock(sourceCidrBlock?.applyValue({ args0 -> args0 }))
            .sourcePortRange(sourcePortRange?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trafficDirection(trafficDirection?.applyValue({ args0 -> args0 }))
            .trafficMirrorFilterId(trafficMirrorFilterId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficMirrorFilterRuleArgs].
 */
@PulumiTagMarker
public class TrafficMirrorFilterRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationCidrBlock: Output<String>? = null

    private var destinationPortRange: Output<TrafficMirrorFilterRuleDestinationPortRangeArgs>? = null

    private var protocol: Output<Int>? = null

    private var ruleAction: Output<String>? = null

    private var ruleNumber: Output<Int>? = null

    private var sourceCidrBlock: Output<String>? = null

    private var sourcePortRange: Output<TrafficMirrorFilterRuleSourcePortRangeArgs>? = null

    private var trafficDirection: Output<String>? = null

    private var trafficMirrorFilterId: Output<String>? = null

    /**
     * @param value Description of the traffic mirror filter rule.
     */
    @JvmName("huprimqbulitoshg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Destination CIDR block to assign to the Traffic Mirror rule.
     */
    @JvmName("jesfxmitnxywskde")
    public suspend fun destinationCidrBlock(`value`: Output<String>) {
        this.destinationCidrBlock = value
    }

    /**
     * @param value Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     */
    @JvmName("mmahypjlytyltdjx")
    public suspend
    fun destinationPortRange(`value`: Output<TrafficMirrorFilterRuleDestinationPortRangeArgs>) {
        this.destinationPortRange = value
    }

    /**
     * @param value Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
     */
    @JvmName("vgfbtxyydljlaaak")
    public suspend fun protocol(`value`: Output<Int>) {
        this.protocol = value
    }

    /**
     * @param value Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
     */
    @JvmName("xrclqdxgptgvqcvo")
    public suspend fun ruleAction(`value`: Output<String>) {
        this.ruleAction = value
    }

    /**
     * @param value Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
     */
    @JvmName("qacuajwlngvntqfx")
    public suspend fun ruleNumber(`value`: Output<Int>) {
        this.ruleNumber = value
    }

    /**
     * @param value Source CIDR block to assign to the Traffic Mirror rule.
     */
    @JvmName("bgjvimpbfudloevx")
    public suspend fun sourceCidrBlock(`value`: Output<String>) {
        this.sourceCidrBlock = value
    }

    /**
     * @param value Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     */
    @JvmName("kqisvylwpskyjywo")
    public suspend fun sourcePortRange(`value`: Output<TrafficMirrorFilterRuleSourcePortRangeArgs>) {
        this.sourcePortRange = value
    }

    /**
     * @param value Direction of traffic to be captured. Valid values are `ingress` and `egress`
     * Traffic mirror port range support following attributes:
     */
    @JvmName("txidqrsjlyqfrgna")
    public suspend fun trafficDirection(`value`: Output<String>) {
        this.trafficDirection = value
    }

    /**
     * @param value ID of the traffic mirror filter to which this rule should be added
     */
    @JvmName("rdsacsygsscvoufq")
    public suspend fun trafficMirrorFilterId(`value`: Output<String>) {
        this.trafficMirrorFilterId = value
    }

    /**
     * @param value Description of the traffic mirror filter rule.
     */
    @JvmName("spisouqbklmyhyix")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Destination CIDR block to assign to the Traffic Mirror rule.
     */
    @JvmName("xrtobsrvcsqdnvop")
    public suspend fun destinationCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationCidrBlock = mapped
    }

    /**
     * @param value Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     */
    @JvmName("owukaveetbnbnuio")
    public suspend
    fun destinationPortRange(`value`: TrafficMirrorFilterRuleDestinationPortRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRange = mapped
    }

    /**
     * @param argument Destination port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     */
    @JvmName("oadsdwedrylmivxn")
    public suspend
    fun destinationPortRange(argument: suspend TrafficMirrorFilterRuleDestinationPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = TrafficMirrorFilterRuleDestinationPortRangeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.destinationPortRange = mapped
    }

    /**
     * @param value Protocol number, for example 17 (UDP), to assign to the Traffic Mirror rule. For information about the protocol value, see [Protocol Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml) on the Internet Assigned Numbers Authority (IANA) website.
     */
    @JvmName("yhmfpduafhewvsve")
    public suspend fun protocol(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Action to take (accept | reject) on the filtered traffic. Valid values are `accept` and `reject`
     */
    @JvmName("brevhirlcvoxtywc")
    public suspend fun ruleAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleAction = mapped
    }

    /**
     * @param value Number of the Traffic Mirror rule. This number must be unique for each Traffic Mirror rule in a given direction. The rules are processed in ascending order by rule number.
     */
    @JvmName("ksuacjcknuvobdup")
    public suspend fun ruleNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleNumber = mapped
    }

    /**
     * @param value Source CIDR block to assign to the Traffic Mirror rule.
     */
    @JvmName("xxjvvsahxiehxcej")
    public suspend fun sourceCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceCidrBlock = mapped
    }

    /**
     * @param value Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     */
    @JvmName("hrhnmmjjadpjqwhi")
    public suspend fun sourcePortRange(`value`: TrafficMirrorFilterRuleSourcePortRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRange = mapped
    }

    /**
     * @param argument Source port range. Supported only when the protocol is set to TCP(6) or UDP(17). See Traffic mirror port range documented below
     */
    @JvmName("vnuhddupkxjsleqd")
    public suspend
    fun sourcePortRange(argument: suspend TrafficMirrorFilterRuleSourcePortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = TrafficMirrorFilterRuleSourcePortRangeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sourcePortRange = mapped
    }

    /**
     * @param value Direction of traffic to be captured. Valid values are `ingress` and `egress`
     * Traffic mirror port range support following attributes:
     */
    @JvmName("kbomyygjpfpqqfmy")
    public suspend fun trafficDirection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficDirection = mapped
    }

    /**
     * @param value ID of the traffic mirror filter to which this rule should be added
     */
    @JvmName("qewlmmytkneeybkd")
    public suspend fun trafficMirrorFilterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficMirrorFilterId = mapped
    }

    internal fun build(): TrafficMirrorFilterRuleArgs = TrafficMirrorFilterRuleArgs(
        description = description,
        destinationCidrBlock = destinationCidrBlock,
        destinationPortRange = destinationPortRange,
        protocol = protocol,
        ruleAction = ruleAction,
        ruleNumber = ruleNumber,
        sourceCidrBlock = sourceCidrBlock,
        sourcePortRange = sourcePortRange,
        trafficDirection = trafficDirection,
        trafficMirrorFilterId = trafficMirrorFilterId,
    )
}
