@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TrafficMirrorSession].
 */
@PulumiTagMarker
public class TrafficMirrorSessionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficMirrorSessionArgs = TrafficMirrorSessionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficMirrorSessionArgsBuilder.() -> Unit) {
        val builder = TrafficMirrorSessionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TrafficMirrorSession {
        val builtJavaResource = com.pulumi.aws.ec2.TrafficMirrorSession(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrafficMirrorSession(builtJavaResource)
    }
}

/**
 * Provides an Traffic mirror session.
 * Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring
 * ## Example Usage
 * To create a basic traffic mirror session
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.TrafficMirrorFilter;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterArgs;
 * import com.pulumi.aws.ec2.TrafficMirrorTarget;
 * import com.pulumi.aws.ec2.TrafficMirrorTargetArgs;
 * import com.pulumi.aws.ec2.TrafficMirrorSession;
 * import com.pulumi.aws.ec2.TrafficMirrorSessionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var filter = new TrafficMirrorFilter("filter", TrafficMirrorFilterArgs.builder()
 *             .description("traffic mirror filter - example")
 *             .networkServices("amazon-dns")
 *             .build());
 *         var target = new TrafficMirrorTarget("target", TrafficMirrorTargetArgs.builder()
 *             .networkLoadBalancerArn(aws_lb.lb().arn())
 *             .build());
 *         var session = new TrafficMirrorSession("session", TrafficMirrorSessionArgs.builder()
 *             .description("traffic mirror session - example")
 *             .networkInterfaceId(aws_instance.test().primary_network_interface_id())
 *             .sessionNumber(1)
 *             .trafficMirrorFilterId(filter.id())
 *             .trafficMirrorTargetId(target.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import traffic mirror sessions using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/trafficMirrorSession:TrafficMirrorSession session tms-0d8aa3ca35897b82e
 * ```
 *
 */
public class TrafficMirrorSession internal constructor(
    override val javaResource: com.pulumi.aws.ec2.TrafficMirrorSession,
) : KotlinCustomResource(javaResource, TrafficMirrorSessionMapper) {
    /**
     * The ARN of the traffic mirror session.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description of the traffic mirror session.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the source network interface. Not all network interfaces are eligible as mirror sources. On EC2 instances only nitro based instances support mirroring.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The AWS account ID of the session owner.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror.
     */
    public val packetLength: Output<Int>?
        get() = javaResource.packetLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
     */
    public val sessionNumber: Output<Int>
        get() = javaResource.sessionNumber().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * ID of the traffic mirror filter to be used
     */
    public val trafficMirrorFilterId: Output<String>
        get() = javaResource.trafficMirrorFilterId().applyValue({ args0 -> args0 })

    /**
     * ID of the traffic mirror target to be used
     */
    public val trafficMirrorTargetId: Output<String>
        get() = javaResource.trafficMirrorTargetId().applyValue({ args0 -> args0 })

    /**
     * The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see RFC 7348. If you do not specify a VirtualNetworkId, an account-wide unique id is chosen at random.
     */
    public val virtualNetworkId: Output<Int>
        get() = javaResource.virtualNetworkId().applyValue({ args0 -> args0 })
}

public object TrafficMirrorSessionMapper : ResourceMapper<TrafficMirrorSession> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.TrafficMirrorSession::class == javaResource::class

    override fun map(javaResource: Resource): TrafficMirrorSession = TrafficMirrorSession(
        javaResource
            as com.pulumi.aws.ec2.TrafficMirrorSession,
    )
}

/**
 * @see [TrafficMirrorSession].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficMirrorSession].
 */
public suspend fun trafficMirrorSession(
    name: String,
    block: suspend TrafficMirrorSessionResourceBuilder.() -> Unit,
): TrafficMirrorSession {
    val builder = TrafficMirrorSessionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficMirrorSession].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficMirrorSession(name: String): TrafficMirrorSession {
    val builder = TrafficMirrorSessionResourceBuilder()
    builder.name(name)
    return builder.build()
}
