@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.TrafficMirrorSessionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Traffic mirror session.
 * Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring
 * ## Example Usage
 * To create a basic traffic mirror session
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.TrafficMirrorFilter;
 * import com.pulumi.aws.ec2.TrafficMirrorFilterArgs;
 * import com.pulumi.aws.ec2.TrafficMirrorTarget;
 * import com.pulumi.aws.ec2.TrafficMirrorTargetArgs;
 * import com.pulumi.aws.ec2.TrafficMirrorSession;
 * import com.pulumi.aws.ec2.TrafficMirrorSessionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var filter = new TrafficMirrorFilter("filter", TrafficMirrorFilterArgs.builder()
 *             .description("traffic mirror filter - example")
 *             .networkServices("amazon-dns")
 *             .build());
 *         var target = new TrafficMirrorTarget("target", TrafficMirrorTargetArgs.builder()
 *             .networkLoadBalancerArn(aws_lb.lb().arn())
 *             .build());
 *         var session = new TrafficMirrorSession("session", TrafficMirrorSessionArgs.builder()
 *             .description("traffic mirror session - example")
 *             .networkInterfaceId(aws_instance.test().primary_network_interface_id())
 *             .sessionNumber(1)
 *             .trafficMirrorFilterId(filter.id())
 *             .trafficMirrorTargetId(target.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import traffic mirror sessions using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/trafficMirrorSession:TrafficMirrorSession session tms-0d8aa3ca35897b82e
 * ```
 * @property description A description of the traffic mirror session.
 * @property networkInterfaceId ID of the source network interface. Not all network interfaces are eligible as mirror sources. On EC2 instances only nitro based instances support mirroring.
 * @property packetLength The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror.
 * @property sessionNumber The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property trafficMirrorFilterId ID of the traffic mirror filter to be used
 * @property trafficMirrorTargetId ID of the traffic mirror target to be used
 * @property virtualNetworkId The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see RFC 7348. If you do not specify a VirtualNetworkId, an account-wide unique id is chosen at random.
 */
public data class TrafficMirrorSessionArgs(
    public val description: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val packetLength: Output<Int>? = null,
    public val sessionNumber: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficMirrorFilterId: Output<String>? = null,
    public val trafficMirrorTargetId: Output<String>? = null,
    public val virtualNetworkId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.TrafficMirrorSessionArgs> {
    override fun toJava(): com.pulumi.aws.ec2.TrafficMirrorSessionArgs =
        com.pulumi.aws.ec2.TrafficMirrorSessionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .packetLength(packetLength?.applyValue({ args0 -> args0 }))
            .sessionNumber(sessionNumber?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trafficMirrorFilterId(trafficMirrorFilterId?.applyValue({ args0 -> args0 }))
            .trafficMirrorTargetId(trafficMirrorTargetId?.applyValue({ args0 -> args0 }))
            .virtualNetworkId(virtualNetworkId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrafficMirrorSessionArgs].
 */
@PulumiTagMarker
public class TrafficMirrorSessionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var packetLength: Output<Int>? = null

    private var sessionNumber: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficMirrorFilterId: Output<String>? = null

    private var trafficMirrorTargetId: Output<String>? = null

    private var virtualNetworkId: Output<Int>? = null

    /**
     * @param value A description of the traffic mirror session.
     */
    @JvmName("bbxsoipmwlerkqsu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value ID of the source network interface. Not all network interfaces are eligible as mirror sources. On EC2 instances only nitro based instances support mirroring.
     */
    @JvmName("rpqbuxnsheikpitj")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror.
     */
    @JvmName("feapnouqpcbeqkix")
    public suspend fun packetLength(`value`: Output<Int>) {
        this.packetLength = value
    }

    /**
     * @param value The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
     */
    @JvmName("ifeiieckpgvpqrrl")
    public suspend fun sessionNumber(`value`: Output<Int>) {
        this.sessionNumber = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rjwwrdntgcwjqsfb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ID of the traffic mirror filter to be used
     */
    @JvmName("depbiqxyycgnrnyr")
    public suspend fun trafficMirrorFilterId(`value`: Output<String>) {
        this.trafficMirrorFilterId = value
    }

    /**
     * @param value ID of the traffic mirror target to be used
     */
    @JvmName("tmdwxojxctrtkisl")
    public suspend fun trafficMirrorTargetId(`value`: Output<String>) {
        this.trafficMirrorTargetId = value
    }

    /**
     * @param value The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see RFC 7348. If you do not specify a VirtualNetworkId, an account-wide unique id is chosen at random.
     */
    @JvmName("laivlboxmuvshxdm")
    public suspend fun virtualNetworkId(`value`: Output<Int>) {
        this.virtualNetworkId = value
    }

    /**
     * @param value A description of the traffic mirror session.
     */
    @JvmName("cuqflxmkrxcbvngl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value ID of the source network interface. Not all network interfaces are eligible as mirror sources. On EC2 instances only nitro based instances support mirroring.
     */
    @JvmName("uopedvnhhojwjtfq")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror.
     */
    @JvmName("pnyfggiotfikabqi")
    public suspend fun packetLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packetLength = mapped
    }

    /**
     * @param value The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
     */
    @JvmName("apgsutavmtcmvalg")
    public suspend fun sessionNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionNumber = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("oexrmixueodqsjws")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lofjarbpxtnasrtf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value ID of the traffic mirror filter to be used
     */
    @JvmName("uqmkwxfhwealnthk")
    public suspend fun trafficMirrorFilterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficMirrorFilterId = mapped
    }

    /**
     * @param value ID of the traffic mirror target to be used
     */
    @JvmName("kdqagvalpqhqiyvu")
    public suspend fun trafficMirrorTargetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficMirrorTargetId = mapped
    }

    /**
     * @param value The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see RFC 7348. If you do not specify a VirtualNetworkId, an account-wide unique id is chosen at random.
     */
    @JvmName("xwhsnkxojhqfjnsm")
    public suspend fun virtualNetworkId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkId = mapped
    }

    internal fun build(): TrafficMirrorSessionArgs = TrafficMirrorSessionArgs(
        description = description,
        networkInterfaceId = networkInterfaceId,
        packetLength = packetLength,
        sessionNumber = sessionNumber,
        tags = tags,
        trafficMirrorFilterId = trafficMirrorFilterId,
        trafficMirrorTargetId = trafficMirrorTargetId,
        virtualNetworkId = virtualNetworkId,
    )
}
