@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TrafficMirrorTarget].
 */
@PulumiTagMarker
public class TrafficMirrorTargetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrafficMirrorTargetArgs = TrafficMirrorTargetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrafficMirrorTargetArgsBuilder.() -> Unit) {
        val builder = TrafficMirrorTargetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TrafficMirrorTarget {
        val builtJavaResource = com.pulumi.aws.ec2.TrafficMirrorTarget(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrafficMirrorTarget(builtJavaResource)
    }
}

/**
 * Provides a Traffic mirror target.
 * Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring
 * ## Example Usage
 * To create a basic traffic mirror session
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.TrafficMirrorTarget;
 * import com.pulumi.aws.ec2.TrafficMirrorTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nlb = new TrafficMirrorTarget("nlb", TrafficMirrorTargetArgs.builder()
 *             .description("NLB target")
 *             .networkLoadBalancerArn(aws_lb.lb().arn())
 *             .build());
 *         var eni = new TrafficMirrorTarget("eni", TrafficMirrorTargetArgs.builder()
 *             .description("ENI target")
 *             .networkInterfaceId(aws_instance.test().primary_network_interface_id())
 *             .build());
 *         var gwlb = new TrafficMirrorTarget("gwlb", TrafficMirrorTargetArgs.builder()
 *             .description("GWLB target")
 *             .gatewayLoadBalancerEndpointId(aws_vpc_endpoint.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import traffic mirror targets using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/trafficMirrorTarget:TrafficMirrorTarget target tmt-0c13a005422b86606
 * ```
 *
 */
public class TrafficMirrorTarget internal constructor(
    override val javaResource: com.pulumi.aws.ec2.TrafficMirrorTarget,
) : KotlinCustomResource(javaResource, TrafficMirrorTargetMapper) {
    /**
     * The ARN of the traffic mirror target.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description of the traffic mirror session.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The VPC Endpoint Id of the Gateway Load Balancer that is associated with the target.
     */
    public val gatewayLoadBalancerEndpointId: Output<String>?
        get() = javaResource.gatewayLoadBalancerEndpointId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The network interface ID that is associated with the target.
     */
    public val networkInterfaceId: Output<String>?
        get() = javaResource.networkInterfaceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target.
     */
    public val networkLoadBalancerArn: Output<String>?
        get() = javaResource.networkLoadBalancerArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the AWS account that owns the traffic mirror target.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * **NOTE:** Either `network_interface_id` or `network_load_balancer_arn` should be specified and both should not be specified together
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object TrafficMirrorTargetMapper : ResourceMapper<TrafficMirrorTarget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.TrafficMirrorTarget::class == javaResource::class

    override fun map(javaResource: Resource): TrafficMirrorTarget = TrafficMirrorTarget(
        javaResource
            as com.pulumi.aws.ec2.TrafficMirrorTarget,
    )
}

/**
 * @see [TrafficMirrorTarget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrafficMirrorTarget].
 */
public suspend fun trafficMirrorTarget(
    name: String,
    block: suspend TrafficMirrorTargetResourceBuilder.() -> Unit,
): TrafficMirrorTarget {
    val builder = TrafficMirrorTargetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrafficMirrorTarget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trafficMirrorTarget(name: String): TrafficMirrorTarget {
    val builder = TrafficMirrorTargetResourceBuilder()
    builder.name(name)
    return builder.build()
}
