@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.TrafficMirrorTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Traffic mirror target.
 * Read [limits and considerations](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html) for traffic mirroring
 * ## Example Usage
 * To create a basic traffic mirror session
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.TrafficMirrorTarget;
 * import com.pulumi.aws.ec2.TrafficMirrorTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nlb = new TrafficMirrorTarget("nlb", TrafficMirrorTargetArgs.builder()
 *             .description("NLB target")
 *             .networkLoadBalancerArn(aws_lb.lb().arn())
 *             .build());
 *         var eni = new TrafficMirrorTarget("eni", TrafficMirrorTargetArgs.builder()
 *             .description("ENI target")
 *             .networkInterfaceId(aws_instance.test().primary_network_interface_id())
 *             .build());
 *         var gwlb = new TrafficMirrorTarget("gwlb", TrafficMirrorTargetArgs.builder()
 *             .description("GWLB target")
 *             .gatewayLoadBalancerEndpointId(aws_vpc_endpoint.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import traffic mirror targets using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/trafficMirrorTarget:TrafficMirrorTarget target tmt-0c13a005422b86606
 * ```
 * @property description A description of the traffic mirror session.
 * @property gatewayLoadBalancerEndpointId The VPC Endpoint Id of the Gateway Load Balancer that is associated with the target.
 * @property networkInterfaceId The network interface ID that is associated with the target.
 * @property networkLoadBalancerArn The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * **NOTE:** Either `network_interface_id` or `network_load_balancer_arn` should be specified and both should not be specified together
 */
public data class TrafficMirrorTargetArgs(
    public val description: Output<String>? = null,
    public val gatewayLoadBalancerEndpointId: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val networkLoadBalancerArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.TrafficMirrorTargetArgs> {
    override fun toJava(): com.pulumi.aws.ec2.TrafficMirrorTargetArgs =
        com.pulumi.aws.ec2.TrafficMirrorTargetArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .gatewayLoadBalancerEndpointId(gatewayLoadBalancerEndpointId?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .networkLoadBalancerArn(networkLoadBalancerArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TrafficMirrorTargetArgs].
 */
@PulumiTagMarker
public class TrafficMirrorTargetArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var gatewayLoadBalancerEndpointId: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var networkLoadBalancerArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description of the traffic mirror session.
     */
    @JvmName("pgvtesfpirmhptsv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The VPC Endpoint Id of the Gateway Load Balancer that is associated with the target.
     */
    @JvmName("gxwjwbuhkvmhufmd")
    public suspend fun gatewayLoadBalancerEndpointId(`value`: Output<String>) {
        this.gatewayLoadBalancerEndpointId = value
    }

    /**
     * @param value The network interface ID that is associated with the target.
     */
    @JvmName("xxdfflrqxarbscqh")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target.
     */
    @JvmName("lyffksxbeoxqpold")
    public suspend fun networkLoadBalancerArn(`value`: Output<String>) {
        this.networkLoadBalancerArn = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * **NOTE:** Either `network_interface_id` or `network_load_balancer_arn` should be specified and both should not be specified together
     */
    @JvmName("wdmbpkmtqealdkom")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description of the traffic mirror session.
     */
    @JvmName("yilwgrruitudhjwf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The VPC Endpoint Id of the Gateway Load Balancer that is associated with the target.
     */
    @JvmName("vjoitfuhtwvcpqrj")
    public suspend fun gatewayLoadBalancerEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayLoadBalancerEndpointId = mapped
    }

    /**
     * @param value The network interface ID that is associated with the target.
     */
    @JvmName("opywconkcftvnevy")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target.
     */
    @JvmName("aufqomcnumciflhy")
    public suspend fun networkLoadBalancerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkLoadBalancerArn = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * **NOTE:** Either `network_interface_id` or `network_load_balancer_arn` should be specified and both should not be specified together
     */
    @JvmName("mdqbxhkhldoyymdf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * **NOTE:** Either `network_interface_id` or `network_load_balancer_arn` should be specified and both should not be specified together
     */
    @JvmName("hekyomwqedegqtqv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TrafficMirrorTargetArgs = TrafficMirrorTargetArgs(
        description = description,
        gatewayLoadBalancerEndpointId = gatewayLoadBalancerEndpointId,
        networkInterfaceId = networkInterfaceId,
        networkLoadBalancerArn = networkLoadBalancerArn,
        tags = tags,
    )
}
