@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VolumeAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AWS EBS Volume Attachment as a top level resource, to attach and
 * detach volumes from AWS Instances.
 * > **NOTE on EBS block devices:** If you use `ebs_block_device` on an `aws.ec2.Instance`, this provider will assume management over the full set of non-root EBS block devices for the instance, and treats additional block devices as drift. For this reason, `ebs_block_device` cannot be mixed with external `aws.ebs.Volume` + `aws.ec2.VolumeAttachment` resources for a given instance.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ebs.Volume;
 * import com.pulumi.aws.ebs.VolumeArgs;
 * import com.pulumi.aws.ec2.VolumeAttachment;
 * import com.pulumi.aws.ec2.VolumeAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var web = new Instance("web", InstanceArgs.builder()
 *             .ami("ami-21f78e11")
 *             .availabilityZone("us-west-2a")
 *             .instanceType("t2.micro")
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *         var example = new Volume("example", VolumeArgs.builder()
 *             .availabilityZone("us-west-2a")
 *             .size(1)
 *             .build());
 *         var ebsAtt = new VolumeAttachment("ebsAtt", VolumeAttachmentArgs.builder()
 *             .deviceName("/dev/sdh")
 *             .volumeId(example.id())
 *             .instanceId(web.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EBS Volume Attachments using `DEVICE_NAME:VOLUME_ID:INSTANCE_ID`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/volumeAttachment:VolumeAttachment example /dev/sdh:vol-049df61146c4d7901:i-12345678
 * ```
 * @property deviceName The device name to expose to the instance (for
 * example, `/dev/sdh` or `xvdh`).  See [Device Naming on Linux Instances](https://docs&#46;aws&#46;amazon&#46;com/AWSEC2/latest/UserGuide/device_naming&#46;html#available-ec2-device-names) and [Device Naming on Windows Instances](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/device_naming.html#available-ec2-device-names) for more information.
 * @property forceDetach Set to `true` if you want to force the
 * volume to detach. Useful if previous attempts failed, but use this option only
 * as a last resort, as this can result in **data loss**. See
 * [Detaching an Amazon EBS Volume from an Instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html) for more information.
 * @property instanceId ID of the Instance to attach to
 * @property skipDestroy Set this to true if you do not wish
 * to detach the volume from the instance to which it is attached at destroy
 * time, and instead just remove the attachment from this provider state. This is
 * useful when destroying an instance which has volumes created by some other
 * means attached.
 * @property stopInstanceBeforeDetaching Set this to true to ensure that the target instance is stopped
 * before trying to detach the volume. Stops the instance, if it is not already stopped.
 * @property volumeId ID of the Volume to be attached
 */
public data class VolumeAttachmentArgs(
    public val deviceName: Output<String>? = null,
    public val forceDetach: Output<Boolean>? = null,
    public val instanceId: Output<String>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val stopInstanceBeforeDetaching: Output<Boolean>? = null,
    public val volumeId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VolumeAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VolumeAttachmentArgs =
        com.pulumi.aws.ec2.VolumeAttachmentArgs.builder()
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .forceDetach(forceDetach?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .stopInstanceBeforeDetaching(stopInstanceBeforeDetaching?.applyValue({ args0 -> args0 }))
            .volumeId(volumeId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeAttachmentArgs].
 */
@PulumiTagMarker
public class VolumeAttachmentArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var forceDetach: Output<Boolean>? = null

    private var instanceId: Output<String>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var stopInstanceBeforeDetaching: Output<Boolean>? = null

    private var volumeId: Output<String>? = null

    /**
     * @param value The device name to expose to the instance (for
     * example, `/dev/sdh` or `xvdh`).  See [Device Naming on Linux Instances](https://docs&#46;aws&#46;amazon&#46;com/AWSEC2/latest/UserGuide/device_naming&#46;html#available-ec2-device-names) and [Device Naming on Windows Instances](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/device_naming.html#available-ec2-device-names) for more information.
     */
    @JvmName("ljapifmqsffccpus")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Set to `true` if you want to force the
     * volume to detach. Useful if previous attempts failed, but use this option only
     * as a last resort, as this can result in **data loss**. See
     * [Detaching an Amazon EBS Volume from an Instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html) for more information.
     */
    @JvmName("wvsduvcshxnonjee")
    public suspend fun forceDetach(`value`: Output<Boolean>) {
        this.forceDetach = value
    }

    /**
     * @param value ID of the Instance to attach to
     */
    @JvmName("byiqdwdcqhxpwgct")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Set this to true if you do not wish
     * to detach the volume from the instance to which it is attached at destroy
     * time, and instead just remove the attachment from this provider state. This is
     * useful when destroying an instance which has volumes created by some other
     * means attached.
     */
    @JvmName("vrsbhcfiqaudyfuq")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value Set this to true to ensure that the target instance is stopped
     * before trying to detach the volume. Stops the instance, if it is not already stopped.
     */
    @JvmName("ohfreoeovvofhpsq")
    public suspend fun stopInstanceBeforeDetaching(`value`: Output<Boolean>) {
        this.stopInstanceBeforeDetaching = value
    }

    /**
     * @param value ID of the Volume to be attached
     */
    @JvmName("ycuduqipfttkevqc")
    public suspend fun volumeId(`value`: Output<String>) {
        this.volumeId = value
    }

    /**
     * @param value The device name to expose to the instance (for
     * example, `/dev/sdh` or `xvdh`).  See [Device Naming on Linux Instances](https://docs&#46;aws&#46;amazon&#46;com/AWSEC2/latest/UserGuide/device_naming&#46;html#available-ec2-device-names) and [Device Naming on Windows Instances](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/device_naming.html#available-ec2-device-names) for more information.
     */
    @JvmName("ufhegaqawsgvyhwm")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Set to `true` if you want to force the
     * volume to detach. Useful if previous attempts failed, but use this option only
     * as a last resort, as this can result in **data loss**. See
     * [Detaching an Amazon EBS Volume from an Instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html) for more information.
     */
    @JvmName("gakwvmxeammdbney")
    public suspend fun forceDetach(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDetach = mapped
    }

    /**
     * @param value ID of the Instance to attach to
     */
    @JvmName("pgadarbveyakjwjc")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Set this to true if you do not wish
     * to detach the volume from the instance to which it is attached at destroy
     * time, and instead just remove the attachment from this provider state. This is
     * useful when destroying an instance which has volumes created by some other
     * means attached.
     */
    @JvmName("cddnbruebgwrnbom")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value Set this to true to ensure that the target instance is stopped
     * before trying to detach the volume. Stops the instance, if it is not already stopped.
     */
    @JvmName("aupdwxtpwldliitr")
    public suspend fun stopInstanceBeforeDetaching(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stopInstanceBeforeDetaching = mapped
    }

    /**
     * @param value ID of the Volume to be attached
     */
    @JvmName("yshiquwrellkhkwm")
    public suspend fun volumeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeId = mapped
    }

    internal fun build(): VolumeAttachmentArgs = VolumeAttachmentArgs(
        deviceName = deviceName,
        forceDetach = forceDetach,
        instanceId = instanceId,
        skipDestroy = skipDestroy,
        stopInstanceBeforeDetaching = stopInstanceBeforeDetaching,
        volumeId = volumeId,
    )
}
