@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC resource.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPCs using the VPC `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpc:Vpc test_vpc vpc-a01106c2
 * ```
 * @property assignGeneratedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block. Default is `false`. Conflicts with `ipv6_ipam_pool_id`
 * @property cidrBlock The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
 * @property enableDnsHostnames A boolean flag to enable/disable DNS hostnames in the VPC. Defaults false.
 * @property enableDnsSupport A boolean flag to enable/disable DNS support in the VPC. Defaults to true.
 * @property enableNetworkAddressUsageMetrics Indicates whether Network Address Usage metrics are enabled for your VPC. Defaults to false.
 * @property instanceTenancy A tenancy option for instances launched into the VPC. Default is `default`, which ensures that EC2 instances launched in this VPC use the EC2 instance tenancy attribute specified when the EC2 instance is launched. The only other option is `dedicated`, which ensures that EC2 instances launched in this VPC are run on dedicated tenancy instances regardless of the tenancy attribute specified at launch. This has a dedicated per region fee of $2 per hour, plus an hourly per instance usage fee.
 * @property ipv4IpamPoolId The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
 * @property ipv4NetmaskLength The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
 * @property ipv6CidrBlock IPv6 CIDR block to request from an IPAM Pool. Can be set explicitly or derived from IPAM using `ipv6_netmask_length`.
 * @property ipv6CidrBlockNetworkBorderGroup By default when an IPv6 CIDR is assigned to a VPC a default ipv6_cidr_block_network_border_group will be set to the region of the VPC. This can be changed to restrict advertisement of public addresses to specific Network Border Groups such as LocalZones.
 * @property ipv6IpamPoolId IPAM Pool ID for a IPv6 pool. Conflicts with `assign_generated_ipv6_cidr_block`.
 * @property ipv6NetmaskLength Netmask length to request from IPAM Pool. Conflicts with `ipv6_cidr_block`. This can be omitted if IPAM pool as a `allocation_default_netmask_length` set. Valid values: `56`.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VpcArgs(
    public val assignGeneratedIpv6CidrBlock: Output<Boolean>? = null,
    public val cidrBlock: Output<String>? = null,
    public val enableDnsHostnames: Output<Boolean>? = null,
    public val enableDnsSupport: Output<Boolean>? = null,
    public val enableNetworkAddressUsageMetrics: Output<Boolean>? = null,
    public val instanceTenancy: Output<String>? = null,
    public val ipv4IpamPoolId: Output<String>? = null,
    public val ipv4NetmaskLength: Output<Int>? = null,
    public val ipv6CidrBlock: Output<String>? = null,
    public val ipv6CidrBlockNetworkBorderGroup: Output<String>? = null,
    public val ipv6IpamPoolId: Output<String>? = null,
    public val ipv6NetmaskLength: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcArgs = com.pulumi.aws.ec2.VpcArgs.builder()
        .assignGeneratedIpv6CidrBlock(assignGeneratedIpv6CidrBlock?.applyValue({ args0 -> args0 }))
        .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
        .enableDnsHostnames(enableDnsHostnames?.applyValue({ args0 -> args0 }))
        .enableDnsSupport(enableDnsSupport?.applyValue({ args0 -> args0 }))
        .enableNetworkAddressUsageMetrics(enableNetworkAddressUsageMetrics?.applyValue({ args0 -> args0 }))
        .instanceTenancy(instanceTenancy?.applyValue({ args0 -> args0 }))
        .ipv4IpamPoolId(ipv4IpamPoolId?.applyValue({ args0 -> args0 }))
        .ipv4NetmaskLength(ipv4NetmaskLength?.applyValue({ args0 -> args0 }))
        .ipv6CidrBlock(ipv6CidrBlock?.applyValue({ args0 -> args0 }))
        .ipv6CidrBlockNetworkBorderGroup(ipv6CidrBlockNetworkBorderGroup?.applyValue({ args0 -> args0 }))
        .ipv6IpamPoolId(ipv6IpamPoolId?.applyValue({ args0 -> args0 }))
        .ipv6NetmaskLength(ipv6NetmaskLength?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [VpcArgs].
 */
@PulumiTagMarker
public class VpcArgsBuilder internal constructor() {
    private var assignGeneratedIpv6CidrBlock: Output<Boolean>? = null

    private var cidrBlock: Output<String>? = null

    private var enableDnsHostnames: Output<Boolean>? = null

    private var enableDnsSupport: Output<Boolean>? = null

    private var enableNetworkAddressUsageMetrics: Output<Boolean>? = null

    private var instanceTenancy: Output<String>? = null

    private var ipv4IpamPoolId: Output<String>? = null

    private var ipv4NetmaskLength: Output<Int>? = null

    private var ipv6CidrBlock: Output<String>? = null

    private var ipv6CidrBlockNetworkBorderGroup: Output<String>? = null

    private var ipv6IpamPoolId: Output<String>? = null

    private var ipv6NetmaskLength: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block. Default is `false`. Conflicts with `ipv6_ipam_pool_id`
     */
    @JvmName("bvycuesacmediuuk")
    public suspend fun assignGeneratedIpv6CidrBlock(`value`: Output<Boolean>) {
        this.assignGeneratedIpv6CidrBlock = value
    }

    /**
     * @param value The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
     */
    @JvmName("cphqpnhcfkufrqyn")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value A boolean flag to enable/disable DNS hostnames in the VPC. Defaults false.
     */
    @JvmName("llqihienjkxgxgnu")
    public suspend fun enableDnsHostnames(`value`: Output<Boolean>) {
        this.enableDnsHostnames = value
    }

    /**
     * @param value A boolean flag to enable/disable DNS support in the VPC. Defaults to true.
     */
    @JvmName("qcykgtribwryrjso")
    public suspend fun enableDnsSupport(`value`: Output<Boolean>) {
        this.enableDnsSupport = value
    }

    /**
     * @param value Indicates whether Network Address Usage metrics are enabled for your VPC. Defaults to false.
     */
    @JvmName("ebpxorwifmhsjify")
    public suspend fun enableNetworkAddressUsageMetrics(`value`: Output<Boolean>) {
        this.enableNetworkAddressUsageMetrics = value
    }

    /**
     * @param value A tenancy option for instances launched into the VPC. Default is `default`, which ensures that EC2 instances launched in this VPC use the EC2 instance tenancy attribute specified when the EC2 instance is launched. The only other option is `dedicated`, which ensures that EC2 instances launched in this VPC are run on dedicated tenancy instances regardless of the tenancy attribute specified at launch. This has a dedicated per region fee of $2 per hour, plus an hourly per instance usage fee.
     */
    @JvmName("ghynnegljomgruuk")
    public suspend fun instanceTenancy(`value`: Output<String>) {
        this.instanceTenancy = value
    }

    /**
     * @param value The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
     */
    @JvmName("vwwmfvjpmfnlfbdm")
    public suspend fun ipv4IpamPoolId(`value`: Output<String>) {
        this.ipv4IpamPoolId = value
    }

    /**
     * @param value The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
     */
    @JvmName("uxnuggtabfqoocvk")
    public suspend fun ipv4NetmaskLength(`value`: Output<Int>) {
        this.ipv4NetmaskLength = value
    }

    /**
     * @param value IPv6 CIDR block to request from an IPAM Pool. Can be set explicitly or derived from IPAM using `ipv6_netmask_length`.
     */
    @JvmName("vkbuxwgyypluxyes")
    public suspend fun ipv6CidrBlock(`value`: Output<String>) {
        this.ipv6CidrBlock = value
    }

    /**
     * @param value By default when an IPv6 CIDR is assigned to a VPC a default ipv6_cidr_block_network_border_group will be set to the region of the VPC. This can be changed to restrict advertisement of public addresses to specific Network Border Groups such as LocalZones.
     */
    @JvmName("gcetbomrcikysujq")
    public suspend fun ipv6CidrBlockNetworkBorderGroup(`value`: Output<String>) {
        this.ipv6CidrBlockNetworkBorderGroup = value
    }

    /**
     * @param value IPAM Pool ID for a IPv6 pool. Conflicts with `assign_generated_ipv6_cidr_block`.
     */
    @JvmName("vapdtpdwxnkuscis")
    public suspend fun ipv6IpamPoolId(`value`: Output<String>) {
        this.ipv6IpamPoolId = value
    }

    /**
     * @param value Netmask length to request from IPAM Pool. Conflicts with `ipv6_cidr_block`. This can be omitted if IPAM pool as a `allocation_default_netmask_length` set. Valid values: `56`.
     */
    @JvmName("ffmmwgrkjhealfil")
    public suspend fun ipv6NetmaskLength(`value`: Output<Int>) {
        this.ipv6NetmaskLength = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nwtofkfindppicbb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block. Default is `false`. Conflicts with `ipv6_ipam_pool_id`
     */
    @JvmName("lkpnaeagxixkunhb")
    public suspend fun assignGeneratedIpv6CidrBlock(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignGeneratedIpv6CidrBlock = mapped
    }

    /**
     * @param value The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
     */
    @JvmName("eskfxayvxinomvmc")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value A boolean flag to enable/disable DNS hostnames in the VPC. Defaults false.
     */
    @JvmName("cyeuagjymhinthdm")
    public suspend fun enableDnsHostnames(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnsHostnames = mapped
    }

    /**
     * @param value A boolean flag to enable/disable DNS support in the VPC. Defaults to true.
     */
    @JvmName("iqjldpwimakdwgvd")
    public suspend fun enableDnsSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnsSupport = mapped
    }

    /**
     * @param value Indicates whether Network Address Usage metrics are enabled for your VPC. Defaults to false.
     */
    @JvmName("uffmybekryyluswh")
    public suspend fun enableNetworkAddressUsageMetrics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNetworkAddressUsageMetrics = mapped
    }

    /**
     * @param value A tenancy option for instances launched into the VPC. Default is `default`, which ensures that EC2 instances launched in this VPC use the EC2 instance tenancy attribute specified when the EC2 instance is launched. The only other option is `dedicated`, which ensures that EC2 instances launched in this VPC are run on dedicated tenancy instances regardless of the tenancy attribute specified at launch. This has a dedicated per region fee of $2 per hour, plus an hourly per instance usage fee.
     */
    @JvmName("fyfplwqrarjxcguh")
    public suspend fun instanceTenancy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTenancy = mapped
    }

    /**
     * @param value The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
     */
    @JvmName("bpeqxsxicogdgjap")
    public suspend fun ipv4IpamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4IpamPoolId = mapped
    }

    /**
     * @param value The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
     */
    @JvmName("fxdmmgtdsindhvlo")
    public suspend fun ipv4NetmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4NetmaskLength = mapped
    }

    /**
     * @param value IPv6 CIDR block to request from an IPAM Pool. Can be set explicitly or derived from IPAM using `ipv6_netmask_length`.
     */
    @JvmName("fbfcskwlllixmovd")
    public suspend fun ipv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlock = mapped
    }

    /**
     * @param value By default when an IPv6 CIDR is assigned to a VPC a default ipv6_cidr_block_network_border_group will be set to the region of the VPC. This can be changed to restrict advertisement of public addresses to specific Network Border Groups such as LocalZones.
     */
    @JvmName("jckbivikpnhqtirf")
    public suspend fun ipv6CidrBlockNetworkBorderGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlockNetworkBorderGroup = mapped
    }

    /**
     * @param value IPAM Pool ID for a IPv6 pool. Conflicts with `assign_generated_ipv6_cidr_block`.
     */
    @JvmName("clowhvrplaickdaa")
    public suspend fun ipv6IpamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6IpamPoolId = mapped
    }

    /**
     * @param value Netmask length to request from IPAM Pool. Conflicts with `ipv6_cidr_block`. This can be omitted if IPAM pool as a `allocation_default_netmask_length` set. Valid values: `56`.
     */
    @JvmName("bsonfhiivccjxijs")
    public suspend fun ipv6NetmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6NetmaskLength = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ugrxrxjnniwbfdma")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mgckrufdlrneqcrq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VpcArgs = VpcArgs(
        assignGeneratedIpv6CidrBlock = assignGeneratedIpv6CidrBlock,
        cidrBlock = cidrBlock,
        enableDnsHostnames = enableDnsHostnames,
        enableDnsSupport = enableDnsSupport,
        enableNetworkAddressUsageMetrics = enableNetworkAddressUsageMetrics,
        instanceTenancy = instanceTenancy,
        ipv4IpamPoolId = ipv4IpamPoolId,
        ipv4NetmaskLength = ipv4NetmaskLength,
        ipv6CidrBlock = ipv6CidrBlock,
        ipv6CidrBlockNetworkBorderGroup = ipv6CidrBlockNetworkBorderGroup,
        ipv6IpamPoolId = ipv6IpamPoolId,
        ipv6NetmaskLength = ipv6NetmaskLength,
        tags = tags,
    )
}
