@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcDhcpOptions].
 */
@PulumiTagMarker
public class VpcDhcpOptionsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcDhcpOptionsArgs = VpcDhcpOptionsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcDhcpOptionsArgsBuilder.() -> Unit) {
        val builder = VpcDhcpOptionsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcDhcpOptions {
        val builtJavaResource = com.pulumi.aws.ec2.VpcDhcpOptions(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcDhcpOptions(builtJavaResource)
    }
}

/**
 * Provides a VPC DHCP Options resource.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcDhcpOptions;
 * import com.pulumi.aws.ec2.VpcDhcpOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dnsResolver = new VpcDhcpOptions("dnsResolver", VpcDhcpOptionsArgs.builder()
 *             .domainNameServers(
 *                 "8.8.8.8",
 *                 "8.8.4.4")
 *             .build());
 *     }
 * }
 * ```
 * ## Remarks
 * * Notice that all arguments are optional but you have to specify at least one argument.
 * * `domain_name_servers`, `netbios_name_servers`, `ntp_servers` are limited by AWS to maximum four servers only.
 * * To actually use the DHCP Options Set you need to associate it to a VPC using `aws.ec2.VpcDhcpOptionsAssociation`.
 * * If you delete a DHCP Options Set, all VPCs using it will be associated to AWS's `default` DHCP Option Set.
 * * In most cases unless you're configuring your own DNS you'll want to set `domain_name_servers` to `AmazonProvidedDNS`.
 * ## Import
 * Using `pulumi import`, import VPC DHCP Options using the DHCP Options `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcDhcpOptions:VpcDhcpOptions my_options dopt-d9070ebb
 * ```
 *
 */
public class VpcDhcpOptions internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcDhcpOptions,
) : KotlinCustomResource(javaResource, VpcDhcpOptionsMapper) {
    /**
     * The ARN of the DHCP Options Set.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * the suffix domain name to use by default when resolving non Fully Qualified Domain Names. In other words, this is what ends up being the `search` value in the `/etc/resolv.conf` file.
     */
    public val domainName: Output<String>?
        get() = javaResource.domainName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of name servers to configure in `/etc/resolv.conf`. If you want to use the default AWS nameservers you should set this to `AmazonProvidedDNS`.
     */
    public val domainNameServers: Output<List<String>>?
        get() = javaResource.domainNameServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of NETBIOS name servers.
     */
    public val netbiosNameServers: Output<List<String>>?
        get() = javaResource.netbiosNameServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The NetBIOS node type (1, 2, 4, or 8). AWS recommends to specify 2 since broadcast and multicast are not supported in their network. For more information about these node types, see [RFC 2132](http://www.ietf.org/rfc/rfc2132.txt).
     */
    public val netbiosNodeType: Output<String>?
        get() = javaResource.netbiosNodeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of NTP servers to configure.
     */
    public val ntpServers: Output<List<String>>?
        get() = javaResource.ntpServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The ID of the AWS account that owns the DHCP options set.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VpcDhcpOptionsMapper : ResourceMapper<VpcDhcpOptions> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcDhcpOptions::class == javaResource::class

    override fun map(javaResource: Resource): VpcDhcpOptions = VpcDhcpOptions(
        javaResource as
            com.pulumi.aws.ec2.VpcDhcpOptions,
    )
}

/**
 * @see [VpcDhcpOptions].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcDhcpOptions].
 */
public suspend fun vpcDhcpOptions(
    name: String,
    block: suspend VpcDhcpOptionsResourceBuilder.() -> Unit,
): VpcDhcpOptions {
    val builder = VpcDhcpOptionsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcDhcpOptions].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcDhcpOptions(name: String): VpcDhcpOptions {
    val builder = VpcDhcpOptionsResourceBuilder()
    builder.name(name)
    return builder.build()
}
