@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcDhcpOptionsAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a VPC DHCP Options Association resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcDhcpOptionsAssociation;
 * import com.pulumi.aws.ec2.VpcDhcpOptionsAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dnsResolver = new VpcDhcpOptionsAssociation("dnsResolver", VpcDhcpOptionsAssociationArgs.builder()
 *             .vpcId(aws_vpc.foo().id())
 *             .dhcpOptionsId(aws_vpc_dhcp_options.foo().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Remarks
 * * You can only associate one DHCP Options Set to a given VPC ID.
 * * Removing the DHCP Options Association automatically sets AWS's `default` DHCP Options Set to the VPC.
 * ## Import
 * Using `pulumi import`, import DHCP associations using the VPC ID associated with the options. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcDhcpOptionsAssociation:VpcDhcpOptionsAssociation imported vpc-0f001273ec18911b1
 * ```
 * @property dhcpOptionsId The ID of the DHCP Options Set to associate to the VPC.
 * @property vpcId The ID of the VPC to which we would like to associate a DHCP Options Set.
 */
public data class VpcDhcpOptionsAssociationArgs(
    public val dhcpOptionsId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcDhcpOptionsAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcDhcpOptionsAssociationArgs =
        com.pulumi.aws.ec2.VpcDhcpOptionsAssociationArgs.builder()
            .dhcpOptionsId(dhcpOptionsId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcDhcpOptionsAssociationArgs].
 */
@PulumiTagMarker
public class VpcDhcpOptionsAssociationArgsBuilder internal constructor() {
    private var dhcpOptionsId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The ID of the DHCP Options Set to associate to the VPC.
     */
    @JvmName("phwrpwdlkvjiqiqm")
    public suspend fun dhcpOptionsId(`value`: Output<String>) {
        this.dhcpOptionsId = value
    }

    /**
     * @param value The ID of the VPC to which we would like to associate a DHCP Options Set.
     */
    @JvmName("tkweitobrxxekayv")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the DHCP Options Set to associate to the VPC.
     */
    @JvmName("kjrofojnjjivsakp")
    public suspend fun dhcpOptionsId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dhcpOptionsId = mapped
    }

    /**
     * @param value The ID of the VPC to which we would like to associate a DHCP Options Set.
     */
    @JvmName("mulucevfnygauyya")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): VpcDhcpOptionsAssociationArgs = VpcDhcpOptionsAssociationArgs(
        dhcpOptionsId = dhcpOptionsId,
        vpcId = vpcId,
    )
}
