@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.VpcEndpointDnsEntry
import com.pulumi.aws.ec2.kotlin.outputs.VpcEndpointDnsOptions
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.VpcEndpointDnsEntry.Companion.toKotlin as vpcEndpointDnsEntryToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.VpcEndpointDnsOptions.Companion.toKotlin as vpcEndpointDnsOptionsToKotlin

/**
 * Builder for [VpcEndpoint].
 */
@PulumiTagMarker
public class VpcEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointArgs = VpcEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointArgsBuilder.() -> Unit) {
        val builder = VpcEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcEndpoint {
        val builtJavaResource = com.pulumi.aws.ec2.VpcEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcEndpoint(builtJavaResource)
    }
}

/**
 * Provides a VPC Endpoint resource.
 * > **NOTE on VPC Endpoints and VPC Endpoint Associations:** The provider provides both standalone VPC Endpoint Associations for
 * Route Tables - (an association between a VPC endpoint and a single `route_table_id`),
 * Security Groups - (an association between a VPC endpoint and a single `security_group_id`),
 * and Subnets - (an association between a VPC endpoint and a single `subnet_id`) and
 * a VPC Endpoint resource with `route_table_ids` and `subnet_ids` attributes.
 * Do not use the same resource ID in both a VPC Endpoint resource and a VPC Endpoint Association resource.
 * Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var s3 = new VpcEndpoint("s3", VpcEndpointArgs.builder()
 *             .vpcId(aws_vpc.main().id())
 *             .serviceName("com.amazonaws.us-west-2.s3")
 *             .build());
 *     }
 * }
 * ```
 * ### Basic w/ Tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var s3 = new VpcEndpoint("s3", VpcEndpointArgs.builder()
 *             .vpcId(aws_vpc.main().id())
 *             .serviceName("com.amazonaws.us-west-2.s3")
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ### Interface Endpoint Type
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ec2 = new VpcEndpoint("ec2", VpcEndpointArgs.builder()
 *             .vpcId(aws_vpc.main().id())
 *             .serviceName("com.amazonaws.us-west-2.ec2")
 *             .vpcEndpointType("Interface")
 *             .securityGroupIds(aws_security_group.sg1().id())
 *             .privateDnsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ### Gateway Load Balancer Endpoint Type
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var exampleVpcEndpointService = new VpcEndpointService("exampleVpcEndpointService", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .allowedPrincipals(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn()))
 *             .gatewayLoadBalancerArns(aws_lb.example().arn())
 *             .build());
 *         var exampleVpcEndpoint = new VpcEndpoint("exampleVpcEndpoint", VpcEndpointArgs.builder()
 *             .serviceName(exampleVpcEndpointService.serviceName())
 *             .subnetIds(aws_subnet.example().id())
 *             .vpcEndpointType(exampleVpcEndpointService.serviceType())
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Endpoints using the VPC endpoint `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcEndpoint:VpcEndpoint endpoint1 vpce-3ecf2a57
 * ```
 *
 */
public class VpcEndpoint internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcEndpoint,
) : KotlinCustomResource(javaResource, VpcEndpointMapper) {
    /**
     * The Amazon Resource Name (ARN) of the VPC endpoint.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Accept the VPC endpoint (the VPC endpoint and service need to be in the same AWS account).
     */
    public val autoAccept: Output<Boolean>?
        get() = javaResource.autoAccept().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of CIDR blocks for the exposed AWS service. Applicable for endpoints of type `Gateway`.
     */
    public val cidrBlocks: Output<List<String>>
        get() = javaResource.cidrBlocks().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The DNS entries for the VPC Endpoint. Applicable for endpoints of type `Interface`. DNS blocks are documented below.
     */
    public val dnsEntries: Output<List<VpcEndpointDnsEntry>>
        get() = javaResource.dnsEntries().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    vpcEndpointDnsEntryToKotlin(args0)
                })
            })
        })

    /**
     * The DNS options for the endpoint. See dns_options below.
     */
    public val dnsOptions: Output<VpcEndpointDnsOptions>
        get() = javaResource.dnsOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                vpcEndpointDnsOptionsToKotlin(args0)
            })
        })

    /**
     * The IP address type for the endpoint. Valid values are `ipv4`, `dualstack`, and `ipv6`.
     */
    public val ipAddressType: Output<String>
        get() = javaResource.ipAddressType().applyValue({ args0 -> args0 })

    /**
     * One or more network interfaces for the VPC Endpoint. Applicable for endpoints of type `Interface`.
     */
    public val networkInterfaceIds: Output<List<String>>
        get() = javaResource.networkInterfaceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the AWS account that owns the VPC endpoint.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * A policy to attach to the endpoint that controls access to the service. This is a JSON formatted string. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The prefix list ID of the exposed AWS service. Applicable for endpoints of type `Gateway`.
     */
    public val prefixListId: Output<String>
        get() = javaResource.prefixListId().applyValue({ args0 -> args0 })

    /**
     * Whether or not to associate a private hosted zone with the specified VPC. Applicable for endpoints of type `Interface`. Most users will want this enabled to allow services within the VPC to automatically use the endpoint.
     * Defaults to `false`.
     */
    public val privateDnsEnabled: Output<Boolean>?
        get() = javaResource.privateDnsEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether or not the VPC Endpoint is being managed by its service - `true` or `false`.
     */
    public val requesterManaged: Output<Boolean>
        get() = javaResource.requesterManaged().applyValue({ args0 -> args0 })

    /**
     * One or more route table IDs. Applicable for endpoints of type `Gateway`.
     */
    public val routeTableIds: Output<List<String>>
        get() = javaResource.routeTableIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of one or more security groups to associate with the network interface. Applicable for endpoints of type `Interface`.
     * If no security groups are specified, the VPC's [default security group](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#DefaultSecurityGroup) is associated with the endpoint.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The service name. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    /**
     * The state of the VPC endpoint.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The ID of one or more subnets in which to create a network interface for the endpoint. Applicable for endpoints of type `GatewayLoadBalancer` and `Interface`. Interface type endpoints cannot function without being assigned to a subnet.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The VPC endpoint type, `Gateway`, `GatewayLoadBalancer`, or `Interface`. Defaults to `Gateway`.
     */
    public val vpcEndpointType: Output<String>?
        get() = javaResource.vpcEndpointType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the VPC in which the endpoint will be used.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object VpcEndpointMapper : ResourceMapper<VpcEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpoint = VpcEndpoint(
        javaResource as
            com.pulumi.aws.ec2.VpcEndpoint,
    )
}

/**
 * @see [VpcEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpoint].
 */
public suspend fun vpcEndpoint(name: String, block: suspend VpcEndpointResourceBuilder.() -> Unit):
    VpcEndpoint {
    val builder = VpcEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpoint(name: String): VpcEndpoint {
    val builder = VpcEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
