@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcEndpointArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.VpcEndpointDnsOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.VpcEndpointDnsOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC Endpoint resource.
 * > **NOTE on VPC Endpoints and VPC Endpoint Associations:** The provider provides both standalone VPC Endpoint Associations for
 * Route Tables - (an association between a VPC endpoint and a single `route_table_id`),
 * Security Groups - (an association between a VPC endpoint and a single `security_group_id`),
 * and Subnets - (an association between a VPC endpoint and a single `subnet_id`) and
 * a VPC Endpoint resource with `route_table_ids` and `subnet_ids` attributes.
 * Do not use the same resource ID in both a VPC Endpoint resource and a VPC Endpoint Association resource.
 * Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var s3 = new VpcEndpoint("s3", VpcEndpointArgs.builder()
 *             .vpcId(aws_vpc.main().id())
 *             .serviceName("com.amazonaws.us-west-2.s3")
 *             .build());
 *     }
 * }
 * ```
 * ### Basic w/ Tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var s3 = new VpcEndpoint("s3", VpcEndpointArgs.builder()
 *             .vpcId(aws_vpc.main().id())
 *             .serviceName("com.amazonaws.us-west-2.s3")
 *             .tags(Map.of("Environment", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ### Interface Endpoint Type
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ec2 = new VpcEndpoint("ec2", VpcEndpointArgs.builder()
 *             .vpcId(aws_vpc.main().id())
 *             .serviceName("com.amazonaws.us-west-2.ec2")
 *             .vpcEndpointType("Interface")
 *             .securityGroupIds(aws_security_group.sg1().id())
 *             .privateDnsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ### Gateway Load Balancer Endpoint Type
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var exampleVpcEndpointService = new VpcEndpointService("exampleVpcEndpointService", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .allowedPrincipals(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn()))
 *             .gatewayLoadBalancerArns(aws_lb.example().arn())
 *             .build());
 *         var exampleVpcEndpoint = new VpcEndpoint("exampleVpcEndpoint", VpcEndpointArgs.builder()
 *             .serviceName(exampleVpcEndpointService.serviceName())
 *             .subnetIds(aws_subnet.example().id())
 *             .vpcEndpointType(exampleVpcEndpointService.serviceType())
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Endpoints using the VPC endpoint `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcEndpoint:VpcEndpoint endpoint1 vpce-3ecf2a57
 * ```
 * @property autoAccept Accept the VPC endpoint (the VPC endpoint and service need to be in the same AWS account).
 * @property dnsOptions The DNS options for the endpoint. See dns_options below.
 * @property ipAddressType The IP address type for the endpoint. Valid values are `ipv4`, `dualstack`, and `ipv6`.
 * @property policy A policy to attach to the endpoint that controls access to the service. This is a JSON formatted string. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
 * @property privateDnsEnabled Whether or not to associate a private hosted zone with the specified VPC. Applicable for endpoints of type `Interface`. Most users will want this enabled to allow services within the VPC to automatically use the endpoint.
 * Defaults to `false`.
 * @property routeTableIds One or more route table IDs. Applicable for endpoints of type `Gateway`.
 * @property securityGroupIds The ID of one or more security groups to associate with the network interface. Applicable for endpoints of type `Interface`.
 * If no security groups are specified, the VPC's [default security group](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#DefaultSecurityGroup) is associated with the endpoint.
 * @property serviceName The service name. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
 * @property subnetIds The ID of one or more subnets in which to create a network interface for the endpoint. Applicable for endpoints of type `GatewayLoadBalancer` and `Interface`. Interface type endpoints cannot function without being assigned to a subnet.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcEndpointType The VPC endpoint type, `Gateway`, `GatewayLoadBalancer`, or `Interface`. Defaults to `Gateway`.
 * @property vpcId The ID of the VPC in which the endpoint will be used.
 */
public data class VpcEndpointArgs(
    public val autoAccept: Output<Boolean>? = null,
    public val dnsOptions: Output<VpcEndpointDnsOptionsArgs>? = null,
    public val ipAddressType: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val privateDnsEnabled: Output<Boolean>? = null,
    public val routeTableIds: Output<List<String>>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val serviceName: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcEndpointType: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcEndpointArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcEndpointArgs =
        com.pulumi.aws.ec2.VpcEndpointArgs.builder()
            .autoAccept(autoAccept?.applyValue({ args0 -> args0 }))
            .dnsOptions(dnsOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipAddressType(ipAddressType?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .privateDnsEnabled(privateDnsEnabled?.applyValue({ args0 -> args0 }))
            .routeTableIds(routeTableIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcEndpointType(vpcEndpointType?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointArgs].
 */
@PulumiTagMarker
public class VpcEndpointArgsBuilder internal constructor() {
    private var autoAccept: Output<Boolean>? = null

    private var dnsOptions: Output<VpcEndpointDnsOptionsArgs>? = null

    private var ipAddressType: Output<String>? = null

    private var policy: Output<String>? = null

    private var privateDnsEnabled: Output<Boolean>? = null

    private var routeTableIds: Output<List<String>>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var serviceName: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcEndpointType: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Accept the VPC endpoint (the VPC endpoint and service need to be in the same AWS account).
     */
    @JvmName("mdssmtlhkyrbeqcm")
    public suspend fun autoAccept(`value`: Output<Boolean>) {
        this.autoAccept = value
    }

    /**
     * @param value The DNS options for the endpoint. See dns_options below.
     */
    @JvmName("okxtktkhtjarwvyh")
    public suspend fun dnsOptions(`value`: Output<VpcEndpointDnsOptionsArgs>) {
        this.dnsOptions = value
    }

    /**
     * @param value The IP address type for the endpoint. Valid values are `ipv4`, `dualstack`, and `ipv6`.
     */
    @JvmName("rtxrpybrpucabpui")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value A policy to attach to the endpoint that controls access to the service. This is a JSON formatted string. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
     */
    @JvmName("tixgmqqqyqvxbrne")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Whether or not to associate a private hosted zone with the specified VPC. Applicable for endpoints of type `Interface`. Most users will want this enabled to allow services within the VPC to automatically use the endpoint.
     * Defaults to `false`.
     */
    @JvmName("exixddxbwpwlxrxc")
    public suspend fun privateDnsEnabled(`value`: Output<Boolean>) {
        this.privateDnsEnabled = value
    }

    /**
     * @param value One or more route table IDs. Applicable for endpoints of type `Gateway`.
     */
    @JvmName("guojnjchmhnceyus")
    public suspend fun routeTableIds(`value`: Output<List<String>>) {
        this.routeTableIds = value
    }

    @JvmName("cycnvoqrdhderifi")
    public suspend fun routeTableIds(vararg values: Output<String>) {
        this.routeTableIds = Output.all(values.asList())
    }

    /**
     * @param values One or more route table IDs. Applicable for endpoints of type `Gateway`.
     */
    @JvmName("opiccrbvsjcalaht")
    public suspend fun routeTableIds(values: List<Output<String>>) {
        this.routeTableIds = Output.all(values)
    }

    /**
     * @param value The ID of one or more security groups to associate with the network interface. Applicable for endpoints of type `Interface`.
     * If no security groups are specified, the VPC's [default security group](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#DefaultSecurityGroup) is associated with the endpoint.
     */
    @JvmName("dvpsouiqbyaahovm")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("ccabhilgnntyjxct")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The ID of one or more security groups to associate with the network interface. Applicable for endpoints of type `Interface`.
     * If no security groups are specified, the VPC's [default security group](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#DefaultSecurityGroup) is associated with the endpoint.
     */
    @JvmName("gkpeyahvodglnupj")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The service name. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
     */
    @JvmName("cmipoxnqlyoonoga")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The ID of one or more subnets in which to create a network interface for the endpoint. Applicable for endpoints of type `GatewayLoadBalancer` and `Interface`. Interface type endpoints cannot function without being assigned to a subnet.
     */
    @JvmName("cfxmjpiwkuucfjxa")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("qbkkarvarscwxvhm")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The ID of one or more subnets in which to create a network interface for the endpoint. Applicable for endpoints of type `GatewayLoadBalancer` and `Interface`. Interface type endpoints cannot function without being assigned to a subnet.
     */
    @JvmName("omflshvrxatpwcmy")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lyqqthqccdvgpqlr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VPC endpoint type, `Gateway`, `GatewayLoadBalancer`, or `Interface`. Defaults to `Gateway`.
     */
    @JvmName("ytvnujbpgrqnalro")
    public suspend fun vpcEndpointType(`value`: Output<String>) {
        this.vpcEndpointType = value
    }

    /**
     * @param value The ID of the VPC in which the endpoint will be used.
     */
    @JvmName("xmpvbayvlyijioud")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Accept the VPC endpoint (the VPC endpoint and service need to be in the same AWS account).
     */
    @JvmName("mmfbcldckhxycgon")
    public suspend fun autoAccept(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAccept = mapped
    }

    /**
     * @param value The DNS options for the endpoint. See dns_options below.
     */
    @JvmName("boqhthnhvflmyqlb")
    public suspend fun dnsOptions(`value`: VpcEndpointDnsOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsOptions = mapped
    }

    /**
     * @param argument The DNS options for the endpoint. See dns_options below.
     */
    @JvmName("xjhkukckctcvlmee")
    public suspend fun dnsOptions(argument: suspend VpcEndpointDnsOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = VpcEndpointDnsOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsOptions = mapped
    }

    /**
     * @param value The IP address type for the endpoint. Valid values are `ipv4`, `dualstack`, and `ipv6`.
     */
    @JvmName("yphgckwwmgqihakv")
    public suspend fun ipAddressType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value A policy to attach to the endpoint that controls access to the service. This is a JSON formatted string. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
     */
    @JvmName("nuhulbjvfeqajvko")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Whether or not to associate a private hosted zone with the specified VPC. Applicable for endpoints of type `Interface`. Most users will want this enabled to allow services within the VPC to automatically use the endpoint.
     * Defaults to `false`.
     */
    @JvmName("ukriduywwougcpnl")
    public suspend fun privateDnsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsEnabled = mapped
    }

    /**
     * @param value One or more route table IDs. Applicable for endpoints of type `Gateway`.
     */
    @JvmName("essnmhhlltyqomdj")
    public suspend fun routeTableIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableIds = mapped
    }

    /**
     * @param values One or more route table IDs. Applicable for endpoints of type `Gateway`.
     */
    @JvmName("arkxvhfrwnndvvwh")
    public suspend fun routeTableIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeTableIds = mapped
    }

    /**
     * @param value The ID of one or more security groups to associate with the network interface. Applicable for endpoints of type `Interface`.
     * If no security groups are specified, the VPC's [default security group](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#DefaultSecurityGroup) is associated with the endpoint.
     */
    @JvmName("yxbvsgtoeygnebcd")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The ID of one or more security groups to associate with the network interface. Applicable for endpoints of type `Interface`.
     * If no security groups are specified, the VPC's [default security group](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#DefaultSecurityGroup) is associated with the endpoint.
     */
    @JvmName("emkonkhgpktrnvgn")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The service name. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
     */
    @JvmName("fyxlcmohkbbinria")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The ID of one or more subnets in which to create a network interface for the endpoint. Applicable for endpoints of type `GatewayLoadBalancer` and `Interface`. Interface type endpoints cannot function without being assigned to a subnet.
     */
    @JvmName("bbvsaudmxkvdmiwb")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The ID of one or more subnets in which to create a network interface for the endpoint. Applicable for endpoints of type `GatewayLoadBalancer` and `Interface`. Interface type endpoints cannot function without being assigned to a subnet.
     */
    @JvmName("auviplxlsmotlxpq")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gdwvrbgkvremejlm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bjcvhmcpiqitjsgg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VPC endpoint type, `Gateway`, `GatewayLoadBalancer`, or `Interface`. Defaults to `Gateway`.
     */
    @JvmName("yhslauxnshrlahlm")
    public suspend fun vpcEndpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointType = mapped
    }

    /**
     * @param value The ID of the VPC in which the endpoint will be used.
     */
    @JvmName("dxilmfqxmtctfycr")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): VpcEndpointArgs = VpcEndpointArgs(
        autoAccept = autoAccept,
        dnsOptions = dnsOptions,
        ipAddressType = ipAddressType,
        policy = policy,
        privateDnsEnabled = privateDnsEnabled,
        routeTableIds = routeTableIds,
        securityGroupIds = securityGroupIds,
        serviceName = serviceName,
        subnetIds = subnetIds,
        tags = tags,
        vpcEndpointType = vpcEndpointType,
        vpcId = vpcId,
    )
}
