@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcEndpointConnectionAccepter].
 */
@PulumiTagMarker
public class VpcEndpointConnectionAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointConnectionAccepterArgs = VpcEndpointConnectionAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointConnectionAccepterArgsBuilder.() -> Unit) {
        val builder = VpcEndpointConnectionAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcEndpointConnectionAccepter {
        val builtJavaResource =
            com.pulumi.aws.ec2.VpcEndpointConnectionAccepter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VpcEndpointConnectionAccepter(builtJavaResource)
    }
}

/**
 * Provides a resource to accept a pending VPC Endpoint Connection accept request to VPC Endpoint Service.
 * ## Example Usage
 * ### Accept cross-account request
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import com.pulumi.aws.ec2.VpcEndpointConnectionAccepter;
 * import com.pulumi.aws.ec2.VpcEndpointConnectionAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpcEndpointService = new VpcEndpointService("exampleVpcEndpointService", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .networkLoadBalancerArns(aws_lb.example().arn())
 *             .build());
 *         var exampleVpcEndpoint = new VpcEndpoint("exampleVpcEndpoint", VpcEndpointArgs.builder()
 *             .vpcId(aws_vpc.test_alternate().id())
 *             .serviceName(aws_vpc_endpoint_service.test().service_name())
 *             .vpcEndpointType("Interface")
 *             .privateDnsEnabled(false)
 *             .securityGroupIds(aws_security_group.test().id())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.alternate())
 *                 .build());
 *         var exampleVpcEndpointConnectionAccepter = new VpcEndpointConnectionAccepter("exampleVpcEndpointConnectionAccepter", VpcEndpointConnectionAccepterArgs.builder()
 *             .vpcEndpointServiceId(exampleVpcEndpointService.id())
 *             .vpcEndpointId(exampleVpcEndpoint.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Endpoint Services using ID of the connection, which is the `VPC Endpoint Service ID` and `VPC Endpoint ID` separated by underscore (`_`).. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcEndpointConnectionAccepter:VpcEndpointConnectionAccepter foo vpce-svc-0f97a19d3fa8220bc_vpce-010601a6db371e263
 * ```
 *
 */
public class VpcEndpointConnectionAccepter internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcEndpointConnectionAccepter,
) : KotlinCustomResource(javaResource, VpcEndpointConnectionAccepterMapper) {
    /**
     * AWS VPC Endpoint ID.
     */
    public val vpcEndpointId: Output<String>
        get() = javaResource.vpcEndpointId().applyValue({ args0 -> args0 })

    /**
     * AWS VPC Endpoint Service ID.
     */
    public val vpcEndpointServiceId: Output<String>
        get() = javaResource.vpcEndpointServiceId().applyValue({ args0 -> args0 })

    /**
     * State of the VPC Endpoint.
     */
    public val vpcEndpointState: Output<String>
        get() = javaResource.vpcEndpointState().applyValue({ args0 -> args0 })
}

public object VpcEndpointConnectionAccepterMapper : ResourceMapper<VpcEndpointConnectionAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcEndpointConnectionAccepter::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpointConnectionAccepter =
        VpcEndpointConnectionAccepter(
            javaResource as
                com.pulumi.aws.ec2.VpcEndpointConnectionAccepter,
        )
}

/**
 * @see [VpcEndpointConnectionAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpointConnectionAccepter].
 */
public suspend fun vpcEndpointConnectionAccepter(
    name: String,
    block: suspend VpcEndpointConnectionAccepterResourceBuilder.() -> Unit,
):
    VpcEndpointConnectionAccepter {
    val builder = VpcEndpointConnectionAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpointConnectionAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpointConnectionAccepter(name: String): VpcEndpointConnectionAccepter {
    val builder = VpcEndpointConnectionAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
