@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcEndpointConnectionAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to accept a pending VPC Endpoint Connection accept request to VPC Endpoint Service.
 * ## Example Usage
 * ### Accept cross-account request
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import com.pulumi.aws.ec2.VpcEndpointConnectionAccepter;
 * import com.pulumi.aws.ec2.VpcEndpointConnectionAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpcEndpointService = new VpcEndpointService("exampleVpcEndpointService", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .networkLoadBalancerArns(aws_lb.example().arn())
 *             .build());
 *         var exampleVpcEndpoint = new VpcEndpoint("exampleVpcEndpoint", VpcEndpointArgs.builder()
 *             .vpcId(aws_vpc.test_alternate().id())
 *             .serviceName(aws_vpc_endpoint_service.test().service_name())
 *             .vpcEndpointType("Interface")
 *             .privateDnsEnabled(false)
 *             .securityGroupIds(aws_security_group.test().id())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.alternate())
 *                 .build());
 *         var exampleVpcEndpointConnectionAccepter = new VpcEndpointConnectionAccepter("exampleVpcEndpointConnectionAccepter", VpcEndpointConnectionAccepterArgs.builder()
 *             .vpcEndpointServiceId(exampleVpcEndpointService.id())
 *             .vpcEndpointId(exampleVpcEndpoint.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Endpoint Services using ID of the connection, which is the `VPC Endpoint Service ID` and `VPC Endpoint ID` separated by underscore (`_`).. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcEndpointConnectionAccepter:VpcEndpointConnectionAccepter foo vpce-svc-0f97a19d3fa8220bc_vpce-010601a6db371e263
 * ```
 * @property vpcEndpointId AWS VPC Endpoint ID.
 * @property vpcEndpointServiceId AWS VPC Endpoint Service ID.
 */
public data class VpcEndpointConnectionAccepterArgs(
    public val vpcEndpointId: Output<String>? = null,
    public val vpcEndpointServiceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcEndpointConnectionAccepterArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcEndpointConnectionAccepterArgs =
        com.pulumi.aws.ec2.VpcEndpointConnectionAccepterArgs.builder()
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 }))
            .vpcEndpointServiceId(vpcEndpointServiceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointConnectionAccepterArgs].
 */
@PulumiTagMarker
public class VpcEndpointConnectionAccepterArgsBuilder internal constructor() {
    private var vpcEndpointId: Output<String>? = null

    private var vpcEndpointServiceId: Output<String>? = null

    /**
     * @param value AWS VPC Endpoint ID.
     */
    @JvmName("sgeydyvnsgvrdqii")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value AWS VPC Endpoint Service ID.
     */
    @JvmName("ksydgrwxobxsmpwk")
    public suspend fun vpcEndpointServiceId(`value`: Output<String>) {
        this.vpcEndpointServiceId = value
    }

    /**
     * @param value AWS VPC Endpoint ID.
     */
    @JvmName("cwckwaarfsulwktp")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    /**
     * @param value AWS VPC Endpoint Service ID.
     */
    @JvmName("cmgrbiapwecwwlfg")
    public suspend fun vpcEndpointServiceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointServiceId = mapped
    }

    internal fun build(): VpcEndpointConnectionAccepterArgs = VpcEndpointConnectionAccepterArgs(
        vpcEndpointId = vpcEndpointId,
        vpcEndpointServiceId = vpcEndpointServiceId,
    )
}
