@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VpcEndpointConnectionNotification].
 */
@PulumiTagMarker
public class VpcEndpointConnectionNotificationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointConnectionNotificationArgs = VpcEndpointConnectionNotificationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointConnectionNotificationArgsBuilder.() -> Unit) {
        val builder = VpcEndpointConnectionNotificationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcEndpointConnectionNotification {
        val builtJavaResource =
            com.pulumi.aws.ec2.VpcEndpointConnectionNotification(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VpcEndpointConnectionNotification(builtJavaResource)
    }
}

/**
 * Provides a VPC Endpoint connection notification resource.
 * Connection notifications notify subscribers of VPC Endpoint events.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import com.pulumi.aws.ec2.VpcEndpointConnectionNotification;
 * import com.pulumi.aws.ec2.VpcEndpointConnectionNotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var topicPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("vpce.amazonaws.com")
 *                     .build())
 *                 .actions("SNS:Publish")
 *                 .resources("arn:aws:sns:*:*:vpce-notification-topic")
 *                 .build())
 *             .build());
 *         var topicTopic = new Topic("topicTopic", TopicArgs.builder()
 *             .policy(topicPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var fooVpcEndpointService = new VpcEndpointService("fooVpcEndpointService", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .networkLoadBalancerArns(aws_lb.test().arn())
 *             .build());
 *         var fooVpcEndpointConnectionNotification = new VpcEndpointConnectionNotification("fooVpcEndpointConnectionNotification", VpcEndpointConnectionNotificationArgs.builder()
 *             .vpcEndpointServiceId(fooVpcEndpointService.id())
 *             .connectionNotificationArn(topicTopic.arn())
 *             .connectionEvents(
 *                 "Accept",
 *                 "Reject")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Endpoint connection notifications using the VPC endpoint connection notification `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcEndpointConnectionNotification:VpcEndpointConnectionNotification foo vpce-nfn-09e6ed3b4efba2263
 * ```
 *
 */
public class VpcEndpointConnectionNotification internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcEndpointConnectionNotification,
) : KotlinCustomResource(javaResource, VpcEndpointConnectionNotificationMapper) {
    /**
     * One or more endpoint [events](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html#API_CreateVpcEndpointConnectionNotification_RequestParameters) for which to receive notifications.
     * > **NOTE:** One of `vpc_endpoint_service_id` or `vpc_endpoint_id` must be specified.
     */
    public val connectionEvents: Output<List<String>>
        get() = javaResource.connectionEvents().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ARN of the SNS topic for the notifications.
     */
    public val connectionNotificationArn: Output<String>
        get() = javaResource.connectionNotificationArn().applyValue({ args0 -> args0 })

    /**
     * The type of notification.
     */
    public val notificationType: Output<String>
        get() = javaResource.notificationType().applyValue({ args0 -> args0 })

    /**
     * The state of the notification.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC Endpoint to receive notifications for.
     */
    public val vpcEndpointId: Output<String>?
        get() = javaResource.vpcEndpointId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the VPC Endpoint Service to receive notifications for.
     */
    public val vpcEndpointServiceId: Output<String>?
        get() = javaResource.vpcEndpointServiceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VpcEndpointConnectionNotificationMapper :
    ResourceMapper<VpcEndpointConnectionNotification> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcEndpointConnectionNotification::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpointConnectionNotification =
        VpcEndpointConnectionNotification(
            javaResource as
                com.pulumi.aws.ec2.VpcEndpointConnectionNotification,
        )
}

/**
 * @see [VpcEndpointConnectionNotification].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpointConnectionNotification].
 */
public suspend fun vpcEndpointConnectionNotification(
    name: String,
    block: suspend VpcEndpointConnectionNotificationResourceBuilder.() -> Unit,
):
    VpcEndpointConnectionNotification {
    val builder = VpcEndpointConnectionNotificationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpointConnectionNotification].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpointConnectionNotification(name: String): VpcEndpointConnectionNotification {
    val builder = VpcEndpointConnectionNotificationResourceBuilder()
    builder.name(name)
    return builder.build()
}
