@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcEndpointConnectionNotificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a VPC Endpoint connection notification resource.
 * Connection notifications notify subscribers of VPC Endpoint events.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import com.pulumi.aws.ec2.VpcEndpointConnectionNotification;
 * import com.pulumi.aws.ec2.VpcEndpointConnectionNotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var topicPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("vpce.amazonaws.com")
 *                     .build())
 *                 .actions("SNS:Publish")
 *                 .resources("arn:aws:sns:*:*:vpce-notification-topic")
 *                 .build())
 *             .build());
 *         var topicTopic = new Topic("topicTopic", TopicArgs.builder()
 *             .policy(topicPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var fooVpcEndpointService = new VpcEndpointService("fooVpcEndpointService", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .networkLoadBalancerArns(aws_lb.test().arn())
 *             .build());
 *         var fooVpcEndpointConnectionNotification = new VpcEndpointConnectionNotification("fooVpcEndpointConnectionNotification", VpcEndpointConnectionNotificationArgs.builder()
 *             .vpcEndpointServiceId(fooVpcEndpointService.id())
 *             .connectionNotificationArn(topicTopic.arn())
 *             .connectionEvents(
 *                 "Accept",
 *                 "Reject")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Endpoint connection notifications using the VPC endpoint connection notification `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcEndpointConnectionNotification:VpcEndpointConnectionNotification foo vpce-nfn-09e6ed3b4efba2263
 * ```
 * @property connectionEvents One or more endpoint [events](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html#API_CreateVpcEndpointConnectionNotification_RequestParameters) for which to receive notifications.
 * > **NOTE:** One of `vpc_endpoint_service_id` or `vpc_endpoint_id` must be specified.
 * @property connectionNotificationArn The ARN of the SNS topic for the notifications.
 * @property vpcEndpointId The ID of the VPC Endpoint to receive notifications for.
 * @property vpcEndpointServiceId The ID of the VPC Endpoint Service to receive notifications for.
 */
public data class VpcEndpointConnectionNotificationArgs(
    public val connectionEvents: Output<List<String>>? = null,
    public val connectionNotificationArn: Output<String>? = null,
    public val vpcEndpointId: Output<String>? = null,
    public val vpcEndpointServiceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcEndpointConnectionNotificationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcEndpointConnectionNotificationArgs =
        com.pulumi.aws.ec2.VpcEndpointConnectionNotificationArgs.builder()
            .connectionEvents(connectionEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectionNotificationArn(connectionNotificationArn?.applyValue({ args0 -> args0 }))
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 }))
            .vpcEndpointServiceId(vpcEndpointServiceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointConnectionNotificationArgs].
 */
@PulumiTagMarker
public class VpcEndpointConnectionNotificationArgsBuilder internal constructor() {
    private var connectionEvents: Output<List<String>>? = null

    private var connectionNotificationArn: Output<String>? = null

    private var vpcEndpointId: Output<String>? = null

    private var vpcEndpointServiceId: Output<String>? = null

    /**
     * @param value One or more endpoint [events](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html#API_CreateVpcEndpointConnectionNotification_RequestParameters) for which to receive notifications.
     * > **NOTE:** One of `vpc_endpoint_service_id` or `vpc_endpoint_id` must be specified.
     */
    @JvmName("xfgtcjhkfkqmjssw")
    public suspend fun connectionEvents(`value`: Output<List<String>>) {
        this.connectionEvents = value
    }

    @JvmName("dsogdlwwyyfepcou")
    public suspend fun connectionEvents(vararg values: Output<String>) {
        this.connectionEvents = Output.all(values.asList())
    }

    /**
     * @param values One or more endpoint [events](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html#API_CreateVpcEndpointConnectionNotification_RequestParameters) for which to receive notifications.
     * > **NOTE:** One of `vpc_endpoint_service_id` or `vpc_endpoint_id` must be specified.
     */
    @JvmName("himcydopetypubrc")
    public suspend fun connectionEvents(values: List<Output<String>>) {
        this.connectionEvents = Output.all(values)
    }

    /**
     * @param value The ARN of the SNS topic for the notifications.
     */
    @JvmName("mcetactdiyrukfbk")
    public suspend fun connectionNotificationArn(`value`: Output<String>) {
        this.connectionNotificationArn = value
    }

    /**
     * @param value The ID of the VPC Endpoint to receive notifications for.
     */
    @JvmName("pvyhrndyejqvjtwg")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value The ID of the VPC Endpoint Service to receive notifications for.
     */
    @JvmName("vxofuqofxytcswmp")
    public suspend fun vpcEndpointServiceId(`value`: Output<String>) {
        this.vpcEndpointServiceId = value
    }

    /**
     * @param value One or more endpoint [events](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html#API_CreateVpcEndpointConnectionNotification_RequestParameters) for which to receive notifications.
     * > **NOTE:** One of `vpc_endpoint_service_id` or `vpc_endpoint_id` must be specified.
     */
    @JvmName("jxkjphnrvnlwhsyu")
    public suspend fun connectionEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionEvents = mapped
    }

    /**
     * @param values One or more endpoint [events](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html#API_CreateVpcEndpointConnectionNotification_RequestParameters) for which to receive notifications.
     * > **NOTE:** One of `vpc_endpoint_service_id` or `vpc_endpoint_id` must be specified.
     */
    @JvmName("ekoywktufcpptlqj")
    public suspend fun connectionEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionEvents = mapped
    }

    /**
     * @param value The ARN of the SNS topic for the notifications.
     */
    @JvmName("ofaddngaodqhelvy")
    public suspend fun connectionNotificationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionNotificationArn = mapped
    }

    /**
     * @param value The ID of the VPC Endpoint to receive notifications for.
     */
    @JvmName("ugadqopomelrswem")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    /**
     * @param value The ID of the VPC Endpoint Service to receive notifications for.
     */
    @JvmName("oqslocmxegipmfpx")
    public suspend fun vpcEndpointServiceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointServiceId = mapped
    }

    internal fun build(): VpcEndpointConnectionNotificationArgs =
        VpcEndpointConnectionNotificationArgs(
            connectionEvents = connectionEvents,
            connectionNotificationArn = connectionNotificationArn,
            vpcEndpointId = vpcEndpointId,
            vpcEndpointServiceId = vpcEndpointServiceId,
        )
}
