@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcEndpointPolicy].
 */
@PulumiTagMarker
public class VpcEndpointPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointPolicyArgs = VpcEndpointPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointPolicyArgsBuilder.() -> Unit) {
        val builder = VpcEndpointPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcEndpointPolicy {
        val builtJavaResource = com.pulumi.aws.ec2.VpcEndpointPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcEndpointPolicy(builtJavaResource)
    }
}

/**
 * Provides a VPC Endpoint Policy resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetVpcEndpointServiceArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import com.pulumi.aws.ec2.VpcEndpointPolicy;
 * import com.pulumi.aws.ec2.VpcEndpointPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var exampleVpcEndpointService = Ec2Functions.getVpcEndpointService(GetVpcEndpointServiceArgs.builder()
 *             .service("dynamodb")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var exampleVpcEndpoint = new VpcEndpoint("exampleVpcEndpoint", VpcEndpointArgs.builder()
 *             .serviceName(exampleVpcEndpointService.applyValue(getVpcEndpointServiceResult -> getVpcEndpointServiceResult.serviceName()))
 *             .vpcId(exampleVpc.id())
 *             .build());
 *         var exampleVpcEndpointPolicy = new VpcEndpointPolicy("exampleVpcEndpointPolicy", VpcEndpointPolicyArgs.builder()
 *             .vpcEndpointId(exampleVpcEndpoint.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", "AllowAll"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", "*")
 *                         )),
 *                         jsonProperty("Action", jsonArray("dynamodb:*")),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Endpoint Policies using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcEndpointPolicy:VpcEndpointPolicy example vpce-3ecf2a57
 * ```
 *
 */
public class VpcEndpointPolicy internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcEndpointPolicy,
) : KotlinCustomResource(javaResource, VpcEndpointPolicyMapper) {
    /**
     * A policy to attach to the endpoint that controls access to the service. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The VPC Endpoint ID.
     */
    public val vpcEndpointId: Output<String>
        get() = javaResource.vpcEndpointId().applyValue({ args0 -> args0 })
}

public object VpcEndpointPolicyMapper : ResourceMapper<VpcEndpointPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcEndpointPolicy::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpointPolicy = VpcEndpointPolicy(
        javaResource as
            com.pulumi.aws.ec2.VpcEndpointPolicy,
    )
}

/**
 * @see [VpcEndpointPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpointPolicy].
 */
public suspend fun vpcEndpointPolicy(
    name: String,
    block: suspend VpcEndpointPolicyResourceBuilder.() -> Unit,
): VpcEndpointPolicy {
    val builder = VpcEndpointPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpointPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpointPolicy(name: String): VpcEndpointPolicy {
    val builder = VpcEndpointPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
