@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcEndpointPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a VPC Endpoint Policy resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetVpcEndpointServiceArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpcEndpoint;
 * import com.pulumi.aws.ec2.VpcEndpointArgs;
 * import com.pulumi.aws.ec2.VpcEndpointPolicy;
 * import com.pulumi.aws.ec2.VpcEndpointPolicyArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var exampleVpcEndpointService = Ec2Functions.getVpcEndpointService(GetVpcEndpointServiceArgs.builder()
 *             .service("dynamodb")
 *             .build());
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var exampleVpcEndpoint = new VpcEndpoint("exampleVpcEndpoint", VpcEndpointArgs.builder()
 *             .serviceName(exampleVpcEndpointService.applyValue(getVpcEndpointServiceResult -> getVpcEndpointServiceResult.serviceName()))
 *             .vpcId(exampleVpc.id())
 *             .build());
 *         var exampleVpcEndpointPolicy = new VpcEndpointPolicy("exampleVpcEndpointPolicy", VpcEndpointPolicyArgs.builder()
 *             .vpcEndpointId(exampleVpcEndpoint.id())
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Sid", "AllowAll"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("AWS", "*")
 *                         )),
 *                         jsonProperty("Action", jsonArray("dynamodb:*")),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Endpoint Policies using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcEndpointPolicy:VpcEndpointPolicy example vpce-3ecf2a57
 * ```
 * @property policy A policy to attach to the endpoint that controls access to the service. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
 * @property vpcEndpointId The VPC Endpoint ID.
 */
public data class VpcEndpointPolicyArgs(
    public val policy: Output<String>? = null,
    public val vpcEndpointId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcEndpointPolicyArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcEndpointPolicyArgs =
        com.pulumi.aws.ec2.VpcEndpointPolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointPolicyArgs].
 */
@PulumiTagMarker
public class VpcEndpointPolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var vpcEndpointId: Output<String>? = null

    /**
     * @param value A policy to attach to the endpoint that controls access to the service. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
     */
    @JvmName("mnhawyohjcilimxx")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The VPC Endpoint ID.
     */
    @JvmName("rqbhfseaqbropxif")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value A policy to attach to the endpoint that controls access to the service. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
     */
    @JvmName("ghygspdxkubqwomw")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The VPC Endpoint ID.
     */
    @JvmName("mgxjwimserskswpi")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    internal fun build(): VpcEndpointPolicyArgs = VpcEndpointPolicyArgs(
        policy = policy,
        vpcEndpointId = vpcEndpointId,
    )
}
