@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.VpcEndpointServicePrivateDnsNameConfiguration
import com.pulumi.aws.ec2.kotlin.outputs.VpcEndpointServicePrivateDnsNameConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcEndpointService].
 */
@PulumiTagMarker
public class VpcEndpointServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointServiceArgs = VpcEndpointServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointServiceArgsBuilder.() -> Unit) {
        val builder = VpcEndpointServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcEndpointService {
        val builtJavaResource = com.pulumi.aws.ec2.VpcEndpointService(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcEndpointService(builtJavaResource)
    }
}

/**
 * Provides a VPC Endpoint Service resource.
 * Service consumers can create an _Interface_ VPC Endpoint to connect to the service.
 * > **NOTE on VPC Endpoint Services and VPC Endpoint Service Allowed Principals:** This provider provides
 * both a standalone VPC Endpoint Service Allowed Principal resource
 * and a VPC Endpoint Service resource with an `allowed_principals` attribute. Do not use the same principal ARN in both
 * a VPC Endpoint Service resource and a VPC Endpoint Service Allowed Principal resource. Doing so will cause a conflict
 * and will overwrite the association.
 * ## Example Usage
 * ### Network Load Balancers
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcEndpointService("example", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .networkLoadBalancerArns(aws_lb.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Gateway Load Balancers
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpointService;
 * import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcEndpointService("example", VpcEndpointServiceArgs.builder()
 *             .acceptanceRequired(false)
 *             .gatewayLoadBalancerArns(aws_lb.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Endpoint Services using the VPC endpoint service `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcEndpointService:VpcEndpointService foo vpce-svc-0f97a19d3fa8220bc
 * ```
 *
 */
public class VpcEndpointService internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcEndpointService,
) : KotlinCustomResource(javaResource, VpcEndpointServiceMapper) {
    /**
     * Whether or not VPC endpoint connection requests to the service must be accepted by the service owner - `true` or `false`.
     */
    public val acceptanceRequired: Output<Boolean>
        get() = javaResource.acceptanceRequired().applyValue({ args0 -> args0 })

    /**
     * The ARNs of one or more principals allowed to discover the endpoint service.
     */
    public val allowedPrincipals: Output<List<String>>
        get() = javaResource.allowedPrincipals().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The Amazon Resource Name (ARN) of the VPC endpoint service.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A set of Availability Zones in which the service is available.
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A set of DNS names for the service.
     */
    public val baseEndpointDnsNames: Output<List<String>>
        get() = javaResource.baseEndpointDnsNames().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Amazon Resource Names (ARNs) of one or more Gateway Load Balancers for the endpoint service.
     */
    public val gatewayLoadBalancerArns: Output<List<String>>?
        get() = javaResource.gatewayLoadBalancerArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Whether or not the service manages its VPC endpoints - `true` or `false`.
     */
    public val managesVpcEndpoints: Output<Boolean>
        get() = javaResource.managesVpcEndpoints().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Names (ARNs) of one or more Network Load Balancers for the endpoint service.
     */
    public val networkLoadBalancerArns: Output<List<String>>?
        get() = javaResource.networkLoadBalancerArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The private DNS name for the service.
     */
    public val privateDnsName: Output<String>
        get() = javaResource.privateDnsName().applyValue({ args0 -> args0 })

    /**
     * List of objects containing information about the endpoint service private DNS name configuration.
     */
    public val privateDnsNameConfigurations:
        Output<List<VpcEndpointServicePrivateDnsNameConfiguration>>
        get() = javaResource.privateDnsNameConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The service name.
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    /**
     * The service type, `Gateway` or `Interface`.
     */
    public val serviceType: Output<String>
        get() = javaResource.serviceType().applyValue({ args0 -> args0 })

    /**
     * Verification state of the VPC endpoint service. Consumers of the endpoint service can use the private name only when the state is `verified`.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The supported IP address types. The possible values are `ipv4` and `ipv6`.
     */
    public val supportedIpAddressTypes: Output<List<String>>
        get() = javaResource.supportedIpAddressTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VpcEndpointServiceMapper : ResourceMapper<VpcEndpointService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcEndpointService::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpointService = VpcEndpointService(
        javaResource as
            com.pulumi.aws.ec2.VpcEndpointService,
    )
}

/**
 * @see [VpcEndpointService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpointService].
 */
public suspend fun vpcEndpointService(
    name: String,
    block: suspend VpcEndpointServiceResourceBuilder.() -> Unit,
): VpcEndpointService {
    val builder = VpcEndpointServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpointService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpointService(name: String): VpcEndpointService {
    val builder = VpcEndpointServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
