@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcEndpointServiceAllowedPrinciple].
 */
@PulumiTagMarker
public class VpcEndpointServiceAllowedPrincipleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcEndpointServiceAllowedPrincipleArgs = VpcEndpointServiceAllowedPrincipleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcEndpointServiceAllowedPrincipleArgsBuilder.() -> Unit) {
        val builder = VpcEndpointServiceAllowedPrincipleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcEndpointServiceAllowedPrinciple {
        val builtJavaResource =
            com.pulumi.aws.ec2.VpcEndpointServiceAllowedPrinciple(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VpcEndpointServiceAllowedPrinciple(builtJavaResource)
    }
}

/**
 * Provides a resource to allow a principal to discover a VPC endpoint service.
 * > **NOTE on VPC Endpoint Services and VPC Endpoint Service Allowed Principals:** This provider provides
 * both a standalone VPC Endpoint Service Allowed Principal resource
 * and a VPC Endpoint Service resource with an `allowed_principals` attribute. Do not use the same principal ARN in both
 * a VPC Endpoint Service resource and a VPC Endpoint Service Allowed Principal resource. Doing so will cause a conflict
 * and will overwrite the association.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpcEndpointServiceAllowedPrinciple;
 * import com.pulumi.aws.ec2.VpcEndpointServiceAllowedPrincipleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var allowMeToFoo = new VpcEndpointServiceAllowedPrinciple("allowMeToFoo", VpcEndpointServiceAllowedPrincipleArgs.builder()
 *             .vpcEndpointServiceId(aws_vpc_endpoint_service.foo().id())
 *             .principalArn(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn()))
 *             .build());
 *     }
 * }
 * ```
 */
public class VpcEndpointServiceAllowedPrinciple internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcEndpointServiceAllowedPrinciple,
) : KotlinCustomResource(javaResource, VpcEndpointServiceAllowedPrincipleMapper) {
    /**
     * The ARN of the principal to allow permissions.
     */
    public val principalArn: Output<String>
        get() = javaResource.principalArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC endpoint service to allow permission.
     */
    public val vpcEndpointServiceId: Output<String>
        get() = javaResource.vpcEndpointServiceId().applyValue({ args0 -> args0 })
}

public object VpcEndpointServiceAllowedPrincipleMapper :
    ResourceMapper<VpcEndpointServiceAllowedPrinciple> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcEndpointServiceAllowedPrinciple::class == javaResource::class

    override fun map(javaResource: Resource): VpcEndpointServiceAllowedPrinciple =
        VpcEndpointServiceAllowedPrinciple(
            javaResource as
                com.pulumi.aws.ec2.VpcEndpointServiceAllowedPrinciple,
        )
}

/**
 * @see [VpcEndpointServiceAllowedPrinciple].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcEndpointServiceAllowedPrinciple].
 */
public suspend fun vpcEndpointServiceAllowedPrinciple(
    name: String,
    block: suspend VpcEndpointServiceAllowedPrincipleResourceBuilder.() -> Unit,
):
    VpcEndpointServiceAllowedPrinciple {
    val builder = VpcEndpointServiceAllowedPrincipleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcEndpointServiceAllowedPrinciple].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcEndpointServiceAllowedPrinciple(name: String): VpcEndpointServiceAllowedPrinciple {
    val builder = VpcEndpointServiceAllowedPrincipleResourceBuilder()
    builder.name(name)
    return builder.build()
}
