@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcEndpointServiceAllowedPrincipleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to allow a principal to discover a VPC endpoint service.
 * > **NOTE on VPC Endpoint Services and VPC Endpoint Service Allowed Principals:** This provider provides
 * both a standalone VPC Endpoint Service Allowed Principal resource
 * and a VPC Endpoint Service resource with an `allowed_principals` attribute. Do not use the same principal ARN in both
 * a VPC Endpoint Service resource and a VPC Endpoint Service Allowed Principal resource. Doing so will cause a conflict
 * and will overwrite the association.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpcEndpointServiceAllowedPrinciple;
 * import com.pulumi.aws.ec2.VpcEndpointServiceAllowedPrincipleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var allowMeToFoo = new VpcEndpointServiceAllowedPrinciple("allowMeToFoo", VpcEndpointServiceAllowedPrincipleArgs.builder()
 *             .vpcEndpointServiceId(aws_vpc_endpoint_service.foo().id())
 *             .principalArn(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.arn()))
 *             .build());
 *     }
 * }
 * ```
 * @property principalArn The ARN of the principal to allow permissions.
 * @property vpcEndpointServiceId The ID of the VPC endpoint service to allow permission.
 */
public data class VpcEndpointServiceAllowedPrincipleArgs(
    public val principalArn: Output<String>? = null,
    public val vpcEndpointServiceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcEndpointServiceAllowedPrincipleArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcEndpointServiceAllowedPrincipleArgs =
        com.pulumi.aws.ec2.VpcEndpointServiceAllowedPrincipleArgs.builder()
            .principalArn(principalArn?.applyValue({ args0 -> args0 }))
            .vpcEndpointServiceId(vpcEndpointServiceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointServiceAllowedPrincipleArgs].
 */
@PulumiTagMarker
public class VpcEndpointServiceAllowedPrincipleArgsBuilder internal constructor() {
    private var principalArn: Output<String>? = null

    private var vpcEndpointServiceId: Output<String>? = null

    /**
     * @param value The ARN of the principal to allow permissions.
     */
    @JvmName("vdciphekvwhcsirs")
    public suspend fun principalArn(`value`: Output<String>) {
        this.principalArn = value
    }

    /**
     * @param value The ID of the VPC endpoint service to allow permission.
     */
    @JvmName("ixfbaiwupeuqvede")
    public suspend fun vpcEndpointServiceId(`value`: Output<String>) {
        this.vpcEndpointServiceId = value
    }

    /**
     * @param value The ARN of the principal to allow permissions.
     */
    @JvmName("njubckyvinghnuql")
    public suspend fun principalArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalArn = mapped
    }

    /**
     * @param value The ID of the VPC endpoint service to allow permission.
     */
    @JvmName("rlgsiqsxfnvjcwec")
    public suspend fun vpcEndpointServiceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointServiceId = mapped
    }

    internal fun build(): VpcEndpointServiceAllowedPrincipleArgs =
        VpcEndpointServiceAllowedPrincipleArgs(
            principalArn = principalArn,
            vpcEndpointServiceId = vpcEndpointServiceId,
        )
}
