@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an association between a VPC endpoint and a subnet.
 * > **NOTE on VPC Endpoints and VPC Endpoint Subnet Associations:** This provider provides
 * both a standalone VPC Endpoint Subnet Association (an association between a VPC endpoint
 * and a single `subnet_id`) and a VPC Endpoint resource with a `subnet_ids`
 * attribute. Do not use the same subnet ID in both a VPC Endpoint resource and a VPC Endpoint Subnet
 * Association resource. Doing so will cause a conflict of associations and will overwrite the association.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcEndpointSubnetAssociation;
 * import com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snEc2 = new VpcEndpointSubnetAssociation("snEc2", VpcEndpointSubnetAssociationArgs.builder()
 *             .vpcEndpointId(aws_vpc_endpoint.ec2().id())
 *             .subnetId(aws_subnet.sn().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Endpoint Subnet Associations using `vpc_endpoint_id` together with `subnet_id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcEndpointSubnetAssociation:VpcEndpointSubnetAssociation example vpce-aaaaaaaa/subnet-bbbbbbbbbbbbbbbbb
 * ```
 * @property subnetId The ID of the subnet to be associated with the VPC endpoint.
 * @property vpcEndpointId The ID of the VPC endpoint with which the subnet will be associated.
 */
public data class VpcEndpointSubnetAssociationArgs(
    public val subnetId: Output<String>? = null,
    public val vpcEndpointId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs =
        com.pulumi.aws.ec2.VpcEndpointSubnetAssociationArgs.builder()
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcEndpointSubnetAssociationArgs].
 */
@PulumiTagMarker
public class VpcEndpointSubnetAssociationArgsBuilder internal constructor() {
    private var subnetId: Output<String>? = null

    private var vpcEndpointId: Output<String>? = null

    /**
     * @param value The ID of the subnet to be associated with the VPC endpoint.
     */
    @JvmName("ktlsmukoqtvtjukn")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The ID of the VPC endpoint with which the subnet will be associated.
     */
    @JvmName("katcsncaoreevjfe")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value The ID of the subnet to be associated with the VPC endpoint.
     */
    @JvmName("rwgicmrjposkbdiu")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value The ID of the VPC endpoint with which the subnet will be associated.
     */
    @JvmName("pypqvlsladchoshm")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    internal fun build(): VpcEndpointSubnetAssociationArgs = VpcEndpointSubnetAssociationArgs(
        subnetId = subnetId,
        vpcEndpointId = vpcEndpointId,
    )
}
