@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.VpcIpamOperatingRegion
import com.pulumi.aws.ec2.kotlin.outputs.VpcIpamOperatingRegion.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcIpam].
 */
@PulumiTagMarker
public class VpcIpamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamArgs = VpcIpamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamArgsBuilder.() -> Unit) {
        val builder = VpcIpamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcIpam {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpam(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpam(builtJavaResource)
    }
}

/**
 * Provides an IPAM resource.
 * ## Import
 * Using `pulumi import`, import IPAMs using the IPAM `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpam:VpcIpam example ipam-0178368ad2146a492
 * ```
 *
 */
public class VpcIpam internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpam,
) : KotlinCustomResource(javaResource, VpcIpamMapper) {
    /**
     * Amazon Resource Name (ARN) of IPAM
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes.
     */
    public val cascade: Output<Boolean>?
        get() = javaResource.cascade().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The IPAM's default resource discovery association ID.
     */
    public val defaultResourceDiscoveryAssociationId: Output<String>
        get() = javaResource.defaultResourceDiscoveryAssociationId().applyValue({ args0 -> args0 })

    /**
     * The IPAM's default resource discovery ID.
     */
    public val defaultResourceDiscoveryId: Output<String>
        get() = javaResource.defaultResourceDiscoveryId().applyValue({ args0 -> args0 })

    /**
     * A description for the IPAM.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    public val operatingRegions: Output<List<VpcIpamOperatingRegion>>
        get() = javaResource.operatingRegions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The ID of the IPAM's private scope. A scope is a top-level container in IPAM. Each scope represents an IP-independent network. Scopes enable you to represent networks where you have overlapping IP space. When you create an IPAM, IPAM automatically creates two scopes: public and private. The private scope is intended for private IP space. The public scope is intended for all internet-routable IP space.
     */
    public val privateDefaultScopeId: Output<String>
        get() = javaResource.privateDefaultScopeId().applyValue({ args0 -> args0 })

    /**
     * The ID of the IPAM's public scope. A scope is a top-level container in IPAM. Each scope represents an IP-independent network. Scopes enable you to represent networks where you have overlapping IP space. When you create an IPAM, IPAM automatically creates two scopes: public and private. The private scope is intended for private
     * IP space. The public scope is intended for all internet-routable IP space.
     */
    public val publicDefaultScopeId: Output<String>
        get() = javaResource.publicDefaultScopeId().applyValue({ args0 -> args0 })

    /**
     * The number of scopes in the IPAM.
     */
    public val scopeCount: Output<Int>
        get() = javaResource.scopeCount().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VpcIpamMapper : ResourceMapper<VpcIpam> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpam::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpam = VpcIpam(
        javaResource as
            com.pulumi.aws.ec2.VpcIpam,
    )
}

/**
 * @see [VpcIpam].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpam].
 */
public suspend fun vpcIpam(name: String, block: suspend VpcIpamResourceBuilder.() -> Unit):
    VpcIpam {
    val builder = VpcIpamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpam].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpam(name: String): VpcIpam {
    val builder = VpcIpamResourceBuilder()
    builder.name(name)
    return builder.build()
}
