@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpamArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.VpcIpamOperatingRegionArgs
import com.pulumi.aws.ec2.kotlin.inputs.VpcIpamOperatingRegionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IPAM resource.
 * ## Import
 * Using `pulumi import`, import IPAMs using the IPAM `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpam:VpcIpam example ipam-0178368ad2146a492
 * ```
 * @property cascade Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes.
 * @property description A description for the IPAM.
 * @property operatingRegions Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VpcIpamArgs(
    public val cascade: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val operatingRegions: Output<List<VpcIpamOperatingRegionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpamArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpamArgs = com.pulumi.aws.ec2.VpcIpamArgs.builder()
        .cascade(cascade?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .operatingRegions(
            operatingRegions?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [VpcIpamArgs].
 */
@PulumiTagMarker
public class VpcIpamArgsBuilder internal constructor() {
    private var cascade: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var operatingRegions: Output<List<VpcIpamOperatingRegionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes.
     */
    @JvmName("qmbxkhvxfiefdlxu")
    public suspend fun cascade(`value`: Output<Boolean>) {
        this.cascade = value
    }

    /**
     * @param value A description for the IPAM.
     */
    @JvmName("uueyqxpjmmlfwamk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("pjpkwriutkgebkyo")
    public suspend fun operatingRegions(`value`: Output<List<VpcIpamOperatingRegionArgs>>) {
        this.operatingRegions = value
    }

    @JvmName("cpqfgejxijjrkdnn")
    public suspend fun operatingRegions(vararg values: Output<VpcIpamOperatingRegionArgs>) {
        this.operatingRegions = Output.all(values.asList())
    }

    /**
     * @param values Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("nulelsibrgkdtveb")
    public suspend fun operatingRegions(values: List<Output<VpcIpamOperatingRegionArgs>>) {
        this.operatingRegions = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("snhumvdwsgxgcayn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Enables you to quickly delete an IPAM, private scopes, pools in private scopes, and any allocations in the pools in private scopes.
     */
    @JvmName("kytlmfqnaqgevfra")
    public suspend fun cascade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cascade = mapped
    }

    /**
     * @param value A description for the IPAM.
     */
    @JvmName("gdwlxbwncmdudbts")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("vhsgvlciexwmgkba")
    public suspend fun operatingRegions(`value`: List<VpcIpamOperatingRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingRegions = mapped
    }

    /**
     * @param argument Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("cktgwusxdoliyvme")
    public suspend
    fun operatingRegions(argument: List<suspend VpcIpamOperatingRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpcIpamOperatingRegionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.operatingRegions = mapped
    }

    /**
     * @param argument Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("phrwmhlyaoqqotqi")
    public suspend fun operatingRegions(
        vararg
        argument: suspend VpcIpamOperatingRegionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpcIpamOperatingRegionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.operatingRegions = mapped
    }

    /**
     * @param argument Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("dekmtqligboypuql")
    public suspend
    fun operatingRegions(argument: suspend VpcIpamOperatingRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpcIpamOperatingRegionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.operatingRegions = mapped
    }

    /**
     * @param values Determines which locales can be chosen when you create pools. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. You **must** set your provider block region as an operating_region.
     */
    @JvmName("wgqupkybtkmqwhew")
    public suspend fun operatingRegions(vararg values: VpcIpamOperatingRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatingRegions = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tjajqxwcbspvwpei")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ugklcuqhbfipbtqw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VpcIpamArgs = VpcIpamArgs(
        cascade = cascade,
        description = description,
        operatingRegions = operatingRegions,
        tags = tags,
    )
}
