@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcIpamOrganizationAdminAccount].
 */
@PulumiTagMarker
public class VpcIpamOrganizationAdminAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamOrganizationAdminAccountArgs = VpcIpamOrganizationAdminAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamOrganizationAdminAccountArgsBuilder.() -> Unit) {
        val builder = VpcIpamOrganizationAdminAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcIpamOrganizationAdminAccount {
        val builtJavaResource =
            com.pulumi.aws.ec2.VpcIpamOrganizationAdminAccount(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VpcIpamOrganizationAdminAccount(builtJavaResource)
    }
}

/**
 * Enables the IPAM Service and promotes a delegated administrator.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpcIpamOrganizationAdminAccount;
 * import com.pulumi.aws.ec2.VpcIpamOrganizationAdminAccountArgs;
 * import com.pulumi.aws.Provider;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var delegated = AwsFunctions.getCallerIdentity();
 *         var example = new VpcIpamOrganizationAdminAccount("example", VpcIpamOrganizationAdminAccountArgs.builder()
 *             .delegatedAdminAccountId(delegated.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .build());
 *         var ipamDelegateAccount = new Provider("ipamDelegateAccount");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IPAMs using the delegate account `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpamOrganizationAdminAccount:VpcIpamOrganizationAdminAccount example 12345678901
 * ```
 *
 */
public class VpcIpamOrganizationAdminAccount internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpamOrganizationAdminAccount,
) : KotlinCustomResource(javaResource, VpcIpamOrganizationAdminAccountMapper) {
    /**
     * The Organizations ARN for the delegate account.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val delegatedAdminAccountId: Output<String>
        get() = javaResource.delegatedAdminAccountId().applyValue({ args0 -> args0 })

    /**
     * The Organizations email for the delegate account.
     */
    public val email: Output<String>
        get() = javaResource.email().applyValue({ args0 -> args0 })

    /**
     * The Organizations name for the delegate account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The AWS service principal.
     */
    public val servicePrincipal: Output<String>
        get() = javaResource.servicePrincipal().applyValue({ args0 -> args0 })
}

public object VpcIpamOrganizationAdminAccountMapper :
    ResourceMapper<VpcIpamOrganizationAdminAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpamOrganizationAdminAccount::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpamOrganizationAdminAccount =
        VpcIpamOrganizationAdminAccount(
            javaResource as
                com.pulumi.aws.ec2.VpcIpamOrganizationAdminAccount,
        )
}

/**
 * @see [VpcIpamOrganizationAdminAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpamOrganizationAdminAccount].
 */
public suspend fun vpcIpamOrganizationAdminAccount(
    name: String,
    block: suspend VpcIpamOrganizationAdminAccountResourceBuilder.() -> Unit,
):
    VpcIpamOrganizationAdminAccount {
    val builder = VpcIpamOrganizationAdminAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpamOrganizationAdminAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpamOrganizationAdminAccount(name: String): VpcIpamOrganizationAdminAccount {
    val builder = VpcIpamOrganizationAdminAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
