@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpamOrganizationAdminAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Enables the IPAM Service and promotes a delegated administrator.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpcIpamOrganizationAdminAccount;
 * import com.pulumi.aws.ec2.VpcIpamOrganizationAdminAccountArgs;
 * import com.pulumi.aws.Provider;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var delegated = AwsFunctions.getCallerIdentity();
 *         var example = new VpcIpamOrganizationAdminAccount("example", VpcIpamOrganizationAdminAccountArgs.builder()
 *             .delegatedAdminAccountId(delegated.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .build());
 *         var ipamDelegateAccount = new Provider("ipamDelegateAccount");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IPAMs using the delegate account `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpamOrganizationAdminAccount:VpcIpamOrganizationAdminAccount example 12345678901
 * ```
 * @property delegatedAdminAccountId
 */
public data class VpcIpamOrganizationAdminAccountArgs(
    public val delegatedAdminAccountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpamOrganizationAdminAccountArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpamOrganizationAdminAccountArgs =
        com.pulumi.aws.ec2.VpcIpamOrganizationAdminAccountArgs.builder()
            .delegatedAdminAccountId(delegatedAdminAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcIpamOrganizationAdminAccountArgs].
 */
@PulumiTagMarker
public class VpcIpamOrganizationAdminAccountArgsBuilder internal constructor() {
    private var delegatedAdminAccountId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("powfqcnadbaoxebe")
    public suspend fun delegatedAdminAccountId(`value`: Output<String>) {
        this.delegatedAdminAccountId = value
    }

    /**
     * @param value
     */
    @JvmName("kmqcxkfanduwiveb")
    public suspend fun delegatedAdminAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegatedAdminAccountId = mapped
    }

    internal fun build(): VpcIpamOrganizationAdminAccountArgs = VpcIpamOrganizationAdminAccountArgs(
        delegatedAdminAccountId = delegatedAdminAccountId,
    )
}
