@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpamPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IP address pool resource for IPAM.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleVpcIpam = new VpcIpam("exampleVpcIpam", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamPool = new VpcIpamPool("exampleVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(exampleVpcIpam.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IPAMs using the IPAM pool `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpamPool:VpcIpamPool example ipam-pool-0958f95207d978e1e
 * ```
 * @property addressFamily The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
 * @property allocationDefaultNetmaskLength A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
 * @property allocationMaxNetmaskLength The maximum netmask length that will be required for CIDR allocations in this pool.
 * @property allocationMinNetmaskLength The minimum netmask length that will be required for CIDR allocations in this pool.
 * @property allocationResourceTags Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
 * @property autoImport If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
 * within the CIDR range in the pool.
 * @property awsService Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
 * @property description A description for the IPAM pool.
 * @property ipamScopeId The ID of the scope in which you would like to create the IPAM pool.
 * @property locale The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. Possible values: Any AWS region, such as `us-east-1`.
 * @property publicIpSource The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
 * @property publiclyAdvertisable Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = "ipv6"` and `public_ip_source = "byoip"`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = "amazon"`.
 * @property sourceIpamPoolId The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VpcIpamPoolArgs(
    public val addressFamily: Output<String>? = null,
    public val allocationDefaultNetmaskLength: Output<Int>? = null,
    public val allocationMaxNetmaskLength: Output<Int>? = null,
    public val allocationMinNetmaskLength: Output<Int>? = null,
    public val allocationResourceTags: Output<Map<String, String>>? = null,
    public val autoImport: Output<Boolean>? = null,
    public val awsService: Output<String>? = null,
    public val description: Output<String>? = null,
    public val ipamScopeId: Output<String>? = null,
    public val locale: Output<String>? = null,
    public val publicIpSource: Output<String>? = null,
    public val publiclyAdvertisable: Output<Boolean>? = null,
    public val sourceIpamPoolId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpamPoolArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpamPoolArgs =
        com.pulumi.aws.ec2.VpcIpamPoolArgs.builder()
            .addressFamily(addressFamily?.applyValue({ args0 -> args0 }))
            .allocationDefaultNetmaskLength(allocationDefaultNetmaskLength?.applyValue({ args0 -> args0 }))
            .allocationMaxNetmaskLength(allocationMaxNetmaskLength?.applyValue({ args0 -> args0 }))
            .allocationMinNetmaskLength(allocationMinNetmaskLength?.applyValue({ args0 -> args0 }))
            .allocationResourceTags(
                allocationResourceTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .autoImport(autoImport?.applyValue({ args0 -> args0 }))
            .awsService(awsService?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .ipamScopeId(ipamScopeId?.applyValue({ args0 -> args0 }))
            .locale(locale?.applyValue({ args0 -> args0 }))
            .publicIpSource(publicIpSource?.applyValue({ args0 -> args0 }))
            .publiclyAdvertisable(publiclyAdvertisable?.applyValue({ args0 -> args0 }))
            .sourceIpamPoolId(sourceIpamPoolId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VpcIpamPoolArgs].
 */
@PulumiTagMarker
public class VpcIpamPoolArgsBuilder internal constructor() {
    private var addressFamily: Output<String>? = null

    private var allocationDefaultNetmaskLength: Output<Int>? = null

    private var allocationMaxNetmaskLength: Output<Int>? = null

    private var allocationMinNetmaskLength: Output<Int>? = null

    private var allocationResourceTags: Output<Map<String, String>>? = null

    private var autoImport: Output<Boolean>? = null

    private var awsService: Output<String>? = null

    private var description: Output<String>? = null

    private var ipamScopeId: Output<String>? = null

    private var locale: Output<String>? = null

    private var publicIpSource: Output<String>? = null

    private var publiclyAdvertisable: Output<Boolean>? = null

    private var sourceIpamPoolId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
     */
    @JvmName("rofomcsxfvpyufdf")
    public suspend fun addressFamily(`value`: Output<String>) {
        this.addressFamily = value
    }

    /**
     * @param value A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
     */
    @JvmName("ddwyfjebkjieysyq")
    public suspend fun allocationDefaultNetmaskLength(`value`: Output<Int>) {
        this.allocationDefaultNetmaskLength = value
    }

    /**
     * @param value The maximum netmask length that will be required for CIDR allocations in this pool.
     */
    @JvmName("tapdxbgnqkdmrimw")
    public suspend fun allocationMaxNetmaskLength(`value`: Output<Int>) {
        this.allocationMaxNetmaskLength = value
    }

    /**
     * @param value The minimum netmask length that will be required for CIDR allocations in this pool.
     */
    @JvmName("udjbubaauvprtjjw")
    public suspend fun allocationMinNetmaskLength(`value`: Output<Int>) {
        this.allocationMinNetmaskLength = value
    }

    /**
     * @param value Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
     */
    @JvmName("nofytrvlohhlopxt")
    public suspend fun allocationResourceTags(`value`: Output<Map<String, String>>) {
        this.allocationResourceTags = value
    }

    /**
     * @param value If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
     * within the CIDR range in the pool.
     */
    @JvmName("wwgldnrnhqbkburl")
    public suspend fun autoImport(`value`: Output<Boolean>) {
        this.autoImport = value
    }

    /**
     * @param value Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
     */
    @JvmName("qbsouugfkvtnrruh")
    public suspend fun awsService(`value`: Output<String>) {
        this.awsService = value
    }

    /**
     * @param value A description for the IPAM pool.
     */
    @JvmName("cybotrcihterdmdb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the scope in which you would like to create the IPAM pool.
     */
    @JvmName("vsihdwbiitvocdms")
    public suspend fun ipamScopeId(`value`: Output<String>) {
        this.ipamScopeId = value
    }

    /**
     * @param value The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. Possible values: Any AWS region, such as `us-east-1`.
     */
    @JvmName("tbawfxllntcomsnj")
    public suspend fun locale(`value`: Output<String>) {
        this.locale = value
    }

    /**
     * @param value The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
     */
    @JvmName("dkqormluywwxchcb")
    public suspend fun publicIpSource(`value`: Output<String>) {
        this.publicIpSource = value
    }

    /**
     * @param value Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = "ipv6"` and `public_ip_source = "byoip"`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = "amazon"`.
     */
    @JvmName("hsmepdmtslrmnrrk")
    public suspend fun publiclyAdvertisable(`value`: Output<Boolean>) {
        this.publiclyAdvertisable = value
    }

    /**
     * @param value The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
     */
    @JvmName("uwunttixwtgheqwx")
    public suspend fun sourceIpamPoolId(`value`: Output<String>) {
        this.sourceIpamPoolId = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dupxyxpappowabll")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The IP protocol assigned to this pool. You must choose either IPv4 or IPv6 protocol for a pool.
     */
    @JvmName("aophtvxikgxwpafr")
    public suspend fun addressFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressFamily = mapped
    }

    /**
     * @param value A default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16 (unless you provide a different netmask value when you create the new allocation).
     */
    @JvmName("gjaeuxcuwlhujbvu")
    public suspend fun allocationDefaultNetmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationDefaultNetmaskLength = mapped
    }

    /**
     * @param value The maximum netmask length that will be required for CIDR allocations in this pool.
     */
    @JvmName("fhtrbmikyqwlhnpf")
    public suspend fun allocationMaxNetmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationMaxNetmaskLength = mapped
    }

    /**
     * @param value The minimum netmask length that will be required for CIDR allocations in this pool.
     */
    @JvmName("kreakbedwdkhjioh")
    public suspend fun allocationMinNetmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationMinNetmaskLength = mapped
    }

    /**
     * @param value Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
     */
    @JvmName("rbfdigpsayyvfoou")
    public suspend fun allocationResourceTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationResourceTags = mapped
    }

    /**
     * @param values Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
     */
    @JvmName("qrwkbwcjumqhcgqj")
    public fun allocationResourceTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationResourceTags = mapped
    }

    /**
     * @param value If you include this argument, IPAM automatically imports any VPCs you have in your scope that fall
     * within the CIDR range in the pool.
     */
    @JvmName("avnxecqrwojtcaoc")
    public suspend fun autoImport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoImport = mapped
    }

    /**
     * @param value Limits which AWS service the pool can be used in. Only useable on public scopes. Valid Values: `ec2`.
     */
    @JvmName("qiqhwoekostnuemc")
    public suspend fun awsService(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsService = mapped
    }

    /**
     * @param value A description for the IPAM pool.
     */
    @JvmName("ndkdaejaokhiewxe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the scope in which you would like to create the IPAM pool.
     */
    @JvmName("kfixaslxlwhccacg")
    public suspend fun ipamScopeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipamScopeId = mapped
    }

    /**
     * @param value The locale in which you would like to create the IPAM pool. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM. You can only create VPCs from a pool whose locale matches the VPC's Region. Possible values: Any AWS region, such as `us-east-1`.
     */
    @JvmName("ekxfariktbhldjkj")
    public suspend fun locale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locale = mapped
    }

    /**
     * @param value The IP address source for pools in the public scope. Only used for provisioning IP address CIDRs to pools in the public scope. Valid values are `byoip` or `amazon`. Default is `byoip`.
     */
    @JvmName("obiknvomlcngdjen")
    public suspend fun publicIpSource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpSource = mapped
    }

    /**
     * @param value Defines whether or not IPv6 pool space is publicly advertisable over the internet. This argument is required if `address_family = "ipv6"` and `public_ip_source = "byoip"`, default is `false`. This option is not available for IPv4 pool space or if `public_ip_source = "amazon"`.
     */
    @JvmName("bqrtsepyfjklevod")
    public suspend fun publiclyAdvertisable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publiclyAdvertisable = mapped
    }

    /**
     * @param value The ID of the source IPAM pool. Use this argument to create a child pool within an existing pool.
     */
    @JvmName("kbomihxeyfhwwypp")
    public suspend fun sourceIpamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpamPoolId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eaokbyowpwfboyte")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jgsceiibylqjhqrs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VpcIpamPoolArgs = VpcIpamPoolArgs(
        addressFamily = addressFamily,
        allocationDefaultNetmaskLength = allocationDefaultNetmaskLength,
        allocationMaxNetmaskLength = allocationMaxNetmaskLength,
        allocationMinNetmaskLength = allocationMinNetmaskLength,
        allocationResourceTags = allocationResourceTags,
        autoImport = autoImport,
        awsService = awsService,
        description = description,
        ipamScopeId = ipamScopeId,
        locale = locale,
        publicIpSource = publicIpSource,
        publiclyAdvertisable = publiclyAdvertisable,
        sourceIpamPoolId = sourceIpamPoolId,
        tags = tags,
    )
}
