@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.VpcIpamPoolCidrCidrAuthorizationContext
import com.pulumi.aws.ec2.kotlin.outputs.VpcIpamPoolCidrCidrAuthorizationContext.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcIpamPoolCidr].
 */
@PulumiTagMarker
public class VpcIpamPoolCidrResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamPoolCidrArgs = VpcIpamPoolCidrArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamPoolCidrArgsBuilder.() -> Unit) {
        val builder = VpcIpamPoolCidrArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcIpamPoolCidr {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpamPoolCidr(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpamPoolCidr(builtJavaResource)
    }
}

/**
 * Provisions a CIDR from an IPAM address pool.
 * > **NOTE:** Provisioning Public IPv4 or Public IPv6 require [steps outside the scope of this resource](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip). The resource accepts `message` and `signature` as part of the `cidr_authorization_context` attribute but those must be generated ahead of time. Public IPv6 CIDRs that are provisioned into a Pool with `publicly_advertisable = true` and all public IPv4 CIDRs also require creating a Route Origin Authorization (ROA) object in your Regional Internet Registry (RIR).
 * > **NOTE:** In order to deprovision CIDRs all Allocations must be released. Allocations created by a VPC take up to 30 minutes to be released. However, for IPAM to properly manage the removal of allocation records created by VPCs and other resources, you must [grant it permissions](https://docs.aws.amazon.com/vpc/latest/ipam/choose-single-user-or-orgs-ipam.html) in
 * either a single account or organizationally. If you are unable to deprovision a cidr after waiting over 30 minutes, you may be missing the Service Linked Role.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleVpcIpam = new VpcIpam("exampleVpcIpam", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamPool = new VpcIpamPool("exampleVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(exampleVpcIpam.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *         var exampleVpcIpamPoolCidr = new VpcIpamPoolCidr("exampleVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/16")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IPAMs using the `<cidr>_<ipam-pool-id>`. For example:
 * __NOTE:__ Do not use the IPAM Pool Cidr ID as this was introduced after the resource already existed.
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpamPoolCidr:VpcIpamPoolCidr example 172.20.0.0/24_ipam-pool-0e634f5a1517cccdc
 * ```
 *
 */
public class VpcIpamPoolCidr internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpamPoolCidr,
) : KotlinCustomResource(javaResource, VpcIpamPoolCidrMapper) {
    /**
     * The CIDR you want to assign to the pool. Conflicts with `netmask_length`.
     */
    public val cidr: Output<String>
        get() = javaResource.cidr().applyValue({ args0 -> args0 })

    /**
     * A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP. This is not stored in the state file. See cidr_authorization_context for more information.
     */
    public val cidrAuthorizationContext: Output<VpcIpamPoolCidrCidrAuthorizationContext>?
        get() = javaResource.cidrAuthorizationContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The unique ID generated by AWS for the pool cidr. Typically this is the resource `id` but this attribute was added to the API calls after the fact and is therefore not used as the resource id.
     */
    public val ipamPoolCidrId: Output<String>
        get() = javaResource.ipamPoolCidrId().applyValue({ args0 -> args0 })

    /**
     * The ID of the pool to which you want to assign a CIDR.
     */
    public val ipamPoolId: Output<String>
        get() = javaResource.ipamPoolId().applyValue({ args0 -> args0 })

    /**
     * If provided, the cidr provisioned into the specified pool will be the next available cidr given this declared netmask length. Conflicts with `cidr`.
     */
    public val netmaskLength: Output<Int>?
        get() = javaResource.netmaskLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VpcIpamPoolCidrMapper : ResourceMapper<VpcIpamPoolCidr> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpamPoolCidr::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpamPoolCidr = VpcIpamPoolCidr(
        javaResource as
            com.pulumi.aws.ec2.VpcIpamPoolCidr,
    )
}

/**
 * @see [VpcIpamPoolCidr].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpamPoolCidr].
 */
public suspend fun vpcIpamPoolCidr(
    name: String,
    block: suspend VpcIpamPoolCidrResourceBuilder.() -> Unit,
): VpcIpamPoolCidr {
    val builder = VpcIpamPoolCidrResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpamPoolCidr].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpamPoolCidr(name: String): VpcIpamPoolCidr {
    val builder = VpcIpamPoolCidrResourceBuilder()
    builder.name(name)
    return builder.build()
}
