@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VpcIpamPoolCidrAllocation].
 */
@PulumiTagMarker
public class VpcIpamPoolCidrAllocationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamPoolCidrAllocationArgs = VpcIpamPoolCidrAllocationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamPoolCidrAllocationArgsBuilder.() -> Unit) {
        val builder = VpcIpamPoolCidrAllocationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcIpamPoolCidrAllocation {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpamPoolCidrAllocation(builtJavaResource)
    }
}

/**
 * Allocates (reserves) a CIDR from an IPAM address pool, preventing usage by IPAM. Only works for private IPv4.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleVpcIpam = new VpcIpam("exampleVpcIpam", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamPool = new VpcIpamPool("exampleVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(exampleVpcIpam.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *         var exampleVpcIpamPoolCidr = new VpcIpamPoolCidr("exampleVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/16")
 *             .build());
 *         var exampleVpcIpamPoolCidrAllocation = new VpcIpamPoolCidrAllocation("exampleVpcIpamPoolCidrAllocation", VpcIpamPoolCidrAllocationArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/24")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleVpcIpamPoolCidr)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IPAM allocations using the allocation `id` and `pool id`, separated by `_`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpamPoolCidrAllocation:VpcIpamPoolCidrAllocation example ipam-pool-alloc-0dc6d196509c049ba8b549ff99f639736_ipam-pool-07cfb559e0921fcbe
 * ```
 *
 */
public class VpcIpamPoolCidrAllocation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation,
) : KotlinCustomResource(javaResource, VpcIpamPoolCidrAllocationMapper) {
    /**
     * The CIDR you want to assign to the pool.
     */
    public val cidr: Output<String>
        get() = javaResource.cidr().applyValue({ args0 -> args0 })

    /**
     * The description for the allocation.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Exclude a particular CIDR range from being returned by the pool.
     */
    public val disallowedCidrs: Output<List<String>>?
        get() = javaResource.disallowedCidrs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val ipamPoolAllocationId: Output<String>
        get() = javaResource.ipamPoolAllocationId().applyValue({ args0 -> args0 })

    /**
     * The ID of the pool to which you want to assign a CIDR.
     */
    public val ipamPoolId: Output<String>
        get() = javaResource.ipamPoolId().applyValue({ args0 -> args0 })

    /**
     * The netmask length of the CIDR you would like to allocate to the IPAM pool. Valid Values: `0-128`.
     */
    public val netmaskLength: Output<Int>?
        get() = javaResource.netmaskLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * The owner of the resource.
     */
    public val resourceOwner: Output<String>
        get() = javaResource.resourceOwner().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })
}

public object VpcIpamPoolCidrAllocationMapper : ResourceMapper<VpcIpamPoolCidrAllocation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpamPoolCidrAllocation =
        VpcIpamPoolCidrAllocation(javaResource as com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation)
}

/**
 * @see [VpcIpamPoolCidrAllocation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpamPoolCidrAllocation].
 */
public suspend fun vpcIpamPoolCidrAllocation(
    name: String,
    block: suspend VpcIpamPoolCidrAllocationResourceBuilder.() -> Unit,
): VpcIpamPoolCidrAllocation {
    val builder = VpcIpamPoolCidrAllocationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpamPoolCidrAllocation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpamPoolCidrAllocation(name: String): VpcIpamPoolCidrAllocation {
    val builder = VpcIpamPoolCidrAllocationResourceBuilder()
    builder.name(name)
    return builder.build()
}
