@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Allocates (reserves) a CIDR from an IPAM address pool, preventing usage by IPAM. Only works for private IPv4.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleVpcIpam = new VpcIpam("exampleVpcIpam", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamPool = new VpcIpamPool("exampleVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(exampleVpcIpam.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *         var exampleVpcIpamPoolCidr = new VpcIpamPoolCidr("exampleVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/16")
 *             .build());
 *         var exampleVpcIpamPoolCidrAllocation = new VpcIpamPoolCidrAllocation("exampleVpcIpamPoolCidrAllocation", VpcIpamPoolCidrAllocationArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/24")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleVpcIpamPoolCidr)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IPAM allocations using the allocation `id` and `pool id`, separated by `_`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpamPoolCidrAllocation:VpcIpamPoolCidrAllocation example ipam-pool-alloc-0dc6d196509c049ba8b549ff99f639736_ipam-pool-07cfb559e0921fcbe
 * ```
 * @property cidr The CIDR you want to assign to the pool.
 * @property description The description for the allocation.
 * @property disallowedCidrs Exclude a particular CIDR range from being returned by the pool.
 * @property ipamPoolId The ID of the pool to which you want to assign a CIDR.
 * @property netmaskLength The netmask length of the CIDR you would like to allocate to the IPAM pool. Valid Values: `0-128`.
 */
public data class VpcIpamPoolCidrAllocationArgs(
    public val cidr: Output<String>? = null,
    public val description: Output<String>? = null,
    public val disallowedCidrs: Output<List<String>>? = null,
    public val ipamPoolId: Output<String>? = null,
    public val netmaskLength: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpamPoolCidrAllocationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpamPoolCidrAllocationArgs =
        com.pulumi.aws.ec2.VpcIpamPoolCidrAllocationArgs.builder()
            .cidr(cidr?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .disallowedCidrs(disallowedCidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipamPoolId(ipamPoolId?.applyValue({ args0 -> args0 }))
            .netmaskLength(netmaskLength?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcIpamPoolCidrAllocationArgs].
 */
@PulumiTagMarker
public class VpcIpamPoolCidrAllocationArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    private var description: Output<String>? = null

    private var disallowedCidrs: Output<List<String>>? = null

    private var ipamPoolId: Output<String>? = null

    private var netmaskLength: Output<Int>? = null

    /**
     * @param value The CIDR you want to assign to the pool.
     */
    @JvmName("pnftcdtpuwccsahb")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value The description for the allocation.
     */
    @JvmName("fgvmqjnjnjpdueet")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Exclude a particular CIDR range from being returned by the pool.
     */
    @JvmName("dsyscvtveuckwdqp")
    public suspend fun disallowedCidrs(`value`: Output<List<String>>) {
        this.disallowedCidrs = value
    }

    @JvmName("pqgemgogmfsavxvw")
    public suspend fun disallowedCidrs(vararg values: Output<String>) {
        this.disallowedCidrs = Output.all(values.asList())
    }

    /**
     * @param values Exclude a particular CIDR range from being returned by the pool.
     */
    @JvmName("exdcecrxvosmcxuv")
    public suspend fun disallowedCidrs(values: List<Output<String>>) {
        this.disallowedCidrs = Output.all(values)
    }

    /**
     * @param value The ID of the pool to which you want to assign a CIDR.
     */
    @JvmName("dtjgmrybhimtifjg")
    public suspend fun ipamPoolId(`value`: Output<String>) {
        this.ipamPoolId = value
    }

    /**
     * @param value The netmask length of the CIDR you would like to allocate to the IPAM pool. Valid Values: `0-128`.
     */
    @JvmName("eonwedvaxmxyxaqf")
    public suspend fun netmaskLength(`value`: Output<Int>) {
        this.netmaskLength = value
    }

    /**
     * @param value The CIDR you want to assign to the pool.
     */
    @JvmName("fpxasysbleqxxset")
    public suspend fun cidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    /**
     * @param value The description for the allocation.
     */
    @JvmName("cfllqrmgwpdaslut")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Exclude a particular CIDR range from being returned by the pool.
     */
    @JvmName("gtwjeitwiatfaaru")
    public suspend fun disallowedCidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disallowedCidrs = mapped
    }

    /**
     * @param values Exclude a particular CIDR range from being returned by the pool.
     */
    @JvmName("fcunqajrgnsaaror")
    public suspend fun disallowedCidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disallowedCidrs = mapped
    }

    /**
     * @param value The ID of the pool to which you want to assign a CIDR.
     */
    @JvmName("jqurqdjoryqawfwm")
    public suspend fun ipamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipamPoolId = mapped
    }

    /**
     * @param value The netmask length of the CIDR you would like to allocate to the IPAM pool. Valid Values: `0-128`.
     */
    @JvmName("hoksexvyepxaqafw")
    public suspend fun netmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netmaskLength = mapped
    }

    internal fun build(): VpcIpamPoolCidrAllocationArgs = VpcIpamPoolCidrAllocationArgs(
        cidr = cidr,
        description = description,
        disallowedCidrs = disallowedCidrs,
        ipamPoolId = ipamPoolId,
        netmaskLength = netmaskLength,
    )
}
