@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.VpcIpamPoolCidrCidrAuthorizationContextArgs
import com.pulumi.aws.ec2.kotlin.inputs.VpcIpamPoolCidrCidrAuthorizationContextArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provisions a CIDR from an IPAM address pool.
 * > **NOTE:** Provisioning Public IPv4 or Public IPv6 require [steps outside the scope of this resource](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip). The resource accepts `message` and `signature` as part of the `cidr_authorization_context` attribute but those must be generated ahead of time. Public IPv6 CIDRs that are provisioned into a Pool with `publicly_advertisable = true` and all public IPv4 CIDRs also require creating a Route Origin Authorization (ROA) object in your Regional Internet Registry (RIR).
 * > **NOTE:** In order to deprovision CIDRs all Allocations must be released. Allocations created by a VPC take up to 30 minutes to be released. However, for IPAM to properly manage the removal of allocation records created by VPCs and other resources, you must [grant it permissions](https://docs.aws.amazon.com/vpc/latest/ipam/choose-single-user-or-orgs-ipam.html) in
 * either a single account or organizationally. If you are unable to deprovision a cidr after waiting over 30 minutes, you may be missing the Service Linked Role.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleVpcIpam = new VpcIpam("exampleVpcIpam", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamPool = new VpcIpamPool("exampleVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(exampleVpcIpam.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *         var exampleVpcIpamPoolCidr = new VpcIpamPoolCidr("exampleVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/16")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IPAMs using the `<cidr>_<ipam-pool-id>`. For example:
 * __NOTE:__ Do not use the IPAM Pool Cidr ID as this was introduced after the resource already existed.
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpamPoolCidr:VpcIpamPoolCidr example 172.20.0.0/24_ipam-pool-0e634f5a1517cccdc
 * ```
 * @property cidr The CIDR you want to assign to the pool. Conflicts with `netmask_length`.
 * @property cidrAuthorizationContext A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP. This is not stored in the state file. See cidr_authorization_context for more information.
 * @property ipamPoolId The ID of the pool to which you want to assign a CIDR.
 * @property netmaskLength If provided, the cidr provisioned into the specified pool will be the next available cidr given this declared netmask length. Conflicts with `cidr`.
 */
public data class VpcIpamPoolCidrArgs(
    public val cidr: Output<String>? = null,
    public val cidrAuthorizationContext: Output<VpcIpamPoolCidrCidrAuthorizationContextArgs>? = null,
    public val ipamPoolId: Output<String>? = null,
    public val netmaskLength: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpamPoolCidrArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpamPoolCidrArgs =
        com.pulumi.aws.ec2.VpcIpamPoolCidrArgs.builder()
            .cidr(cidr?.applyValue({ args0 -> args0 }))
            .cidrAuthorizationContext(
                cidrAuthorizationContext?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ipamPoolId(ipamPoolId?.applyValue({ args0 -> args0 }))
            .netmaskLength(netmaskLength?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcIpamPoolCidrArgs].
 */
@PulumiTagMarker
public class VpcIpamPoolCidrArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    private var cidrAuthorizationContext: Output<VpcIpamPoolCidrCidrAuthorizationContextArgs>? = null

    private var ipamPoolId: Output<String>? = null

    private var netmaskLength: Output<Int>? = null

    /**
     * @param value The CIDR you want to assign to the pool. Conflicts with `netmask_length`.
     */
    @JvmName("gdrldtuidmcacvwf")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP. This is not stored in the state file. See cidr_authorization_context for more information.
     */
    @JvmName("fixmrsxgdlhtdidp")
    public suspend
    fun cidrAuthorizationContext(`value`: Output<VpcIpamPoolCidrCidrAuthorizationContextArgs>) {
        this.cidrAuthorizationContext = value
    }

    /**
     * @param value The ID of the pool to which you want to assign a CIDR.
     */
    @JvmName("ypsekggsruhdcwri")
    public suspend fun ipamPoolId(`value`: Output<String>) {
        this.ipamPoolId = value
    }

    /**
     * @param value If provided, the cidr provisioned into the specified pool will be the next available cidr given this declared netmask length. Conflicts with `cidr`.
     */
    @JvmName("llybhxjfnnsbatre")
    public suspend fun netmaskLength(`value`: Output<Int>) {
        this.netmaskLength = value
    }

    /**
     * @param value The CIDR you want to assign to the pool. Conflicts with `netmask_length`.
     */
    @JvmName("fgjhsjtqgravhxal")
    public suspend fun cidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    /**
     * @param value A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP. This is not stored in the state file. See cidr_authorization_context for more information.
     */
    @JvmName("lmooxuarlpgxmssa")
    public suspend
    fun cidrAuthorizationContext(`value`: VpcIpamPoolCidrCidrAuthorizationContextArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrAuthorizationContext = mapped
    }

    /**
     * @param argument A signed document that proves that you are authorized to bring the specified IP address range to Amazon using BYOIP. This is not stored in the state file. See cidr_authorization_context for more information.
     */
    @JvmName("lwfikcydfrbovetv")
    public suspend
    fun cidrAuthorizationContext(argument: suspend VpcIpamPoolCidrCidrAuthorizationContextArgsBuilder.() -> Unit) {
        val toBeMapped = VpcIpamPoolCidrCidrAuthorizationContextArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cidrAuthorizationContext = mapped
    }

    /**
     * @param value The ID of the pool to which you want to assign a CIDR.
     */
    @JvmName("dnalnrdyjudvbvwj")
    public suspend fun ipamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipamPoolId = mapped
    }

    /**
     * @param value If provided, the cidr provisioned into the specified pool will be the next available cidr given this declared netmask length. Conflicts with `cidr`.
     */
    @JvmName("exejtgverhwqffqa")
    public suspend fun netmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netmaskLength = mapped
    }

    internal fun build(): VpcIpamPoolCidrArgs = VpcIpamPoolCidrArgs(
        cidr = cidr,
        cidrAuthorizationContext = cidrAuthorizationContext,
        ipamPoolId = ipamPoolId,
        netmaskLength = netmaskLength,
    )
}
