@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [VpcIpamPreviewNextCidr].
 */
@PulumiTagMarker
public class VpcIpamPreviewNextCidrResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamPreviewNextCidrArgs = VpcIpamPreviewNextCidrArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamPreviewNextCidrArgsBuilder.() -> Unit) {
        val builder = VpcIpamPreviewNextCidrArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcIpamPreviewNextCidr {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpamPreviewNextCidr(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpamPreviewNextCidr(builtJavaResource)
    }
}

/**
 * Previews a CIDR from an IPAM address pool. Only works for private IPv4.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import com.pulumi.aws.ec2.VpcIpamPreviewNextCidr;
 * import com.pulumi.aws.ec2.VpcIpamPreviewNextCidrArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleVpcIpam = new VpcIpam("exampleVpcIpam", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamPool = new VpcIpamPool("exampleVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(exampleVpcIpam.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *         var exampleVpcIpamPoolCidr = new VpcIpamPoolCidr("exampleVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/16")
 *             .build());
 *         var exampleVpcIpamPreviewNextCidr = new VpcIpamPreviewNextCidr("exampleVpcIpamPreviewNextCidr", VpcIpamPreviewNextCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .netmaskLength(28)
 *             .disallowedCidrs("172.2.0.0/32")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleVpcIpamPoolCidr)
 *                 .build());
 *     }
 * }
 * ```
 */
public class VpcIpamPreviewNextCidr internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpamPreviewNextCidr,
) : KotlinCustomResource(javaResource, VpcIpamPreviewNextCidrMapper) {
    /**
     * The previewed CIDR from the pool.
     */
    public val cidr: Output<String>
        get() = javaResource.cidr().applyValue({ args0 -> args0 })

    /**
     * Exclude a particular CIDR range from being returned by the pool.
     */
    public val disallowedCidrs: Output<List<String>>?
        get() = javaResource.disallowedCidrs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The ID of the pool to which you want to assign a CIDR.
     */
    public val ipamPoolId: Output<String>
        get() = javaResource.ipamPoolId().applyValue({ args0 -> args0 })

    /**
     * The netmask length of the CIDR you would like to preview from the IPAM pool.
     */
    public val netmaskLength: Output<Int>?
        get() = javaResource.netmaskLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VpcIpamPreviewNextCidrMapper : ResourceMapper<VpcIpamPreviewNextCidr> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpamPreviewNextCidr::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpamPreviewNextCidr =
        VpcIpamPreviewNextCidr(javaResource as com.pulumi.aws.ec2.VpcIpamPreviewNextCidr)
}

/**
 * @see [VpcIpamPreviewNextCidr].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpamPreviewNextCidr].
 */
public suspend fun vpcIpamPreviewNextCidr(
    name: String,
    block: suspend VpcIpamPreviewNextCidrResourceBuilder.() -> Unit,
): VpcIpamPreviewNextCidr {
    val builder = VpcIpamPreviewNextCidrResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpamPreviewNextCidr].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpamPreviewNextCidr(name: String): VpcIpamPreviewNextCidr {
    val builder = VpcIpamPreviewNextCidrResourceBuilder()
    builder.name(name)
    return builder.build()
}
