@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpamPreviewNextCidrArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Previews a CIDR from an IPAM address pool. Only works for private IPv4.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamPool;
 * import com.pulumi.aws.ec2.VpcIpamPoolArgs;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidr;
 * import com.pulumi.aws.ec2.VpcIpamPoolCidrArgs;
 * import com.pulumi.aws.ec2.VpcIpamPreviewNextCidr;
 * import com.pulumi.aws.ec2.VpcIpamPreviewNextCidrArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleVpcIpam = new VpcIpam("exampleVpcIpam", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamPool = new VpcIpamPool("exampleVpcIpamPool", VpcIpamPoolArgs.builder()
 *             .addressFamily("ipv4")
 *             .ipamScopeId(exampleVpcIpam.privateDefaultScopeId())
 *             .locale(current.applyValue(getRegionResult -> getRegionResult.name()))
 *             .build());
 *         var exampleVpcIpamPoolCidr = new VpcIpamPoolCidr("exampleVpcIpamPoolCidr", VpcIpamPoolCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .cidr("172.20.0.0/16")
 *             .build());
 *         var exampleVpcIpamPreviewNextCidr = new VpcIpamPreviewNextCidr("exampleVpcIpamPreviewNextCidr", VpcIpamPreviewNextCidrArgs.builder()
 *             .ipamPoolId(exampleVpcIpamPool.id())
 *             .netmaskLength(28)
 *             .disallowedCidrs("172.2.0.0/32")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleVpcIpamPoolCidr)
 *                 .build());
 *     }
 * }
 * ```
 * @property disallowedCidrs Exclude a particular CIDR range from being returned by the pool.
 * @property ipamPoolId The ID of the pool to which you want to assign a CIDR.
 * @property netmaskLength The netmask length of the CIDR you would like to preview from the IPAM pool.
 */
public data class VpcIpamPreviewNextCidrArgs(
    public val disallowedCidrs: Output<List<String>>? = null,
    public val ipamPoolId: Output<String>? = null,
    public val netmaskLength: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpamPreviewNextCidrArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpamPreviewNextCidrArgs =
        com.pulumi.aws.ec2.VpcIpamPreviewNextCidrArgs.builder()
            .disallowedCidrs(disallowedCidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipamPoolId(ipamPoolId?.applyValue({ args0 -> args0 }))
            .netmaskLength(netmaskLength?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcIpamPreviewNextCidrArgs].
 */
@PulumiTagMarker
public class VpcIpamPreviewNextCidrArgsBuilder internal constructor() {
    private var disallowedCidrs: Output<List<String>>? = null

    private var ipamPoolId: Output<String>? = null

    private var netmaskLength: Output<Int>? = null

    /**
     * @param value Exclude a particular CIDR range from being returned by the pool.
     */
    @JvmName("xgcruktdhbhrhyjc")
    public suspend fun disallowedCidrs(`value`: Output<List<String>>) {
        this.disallowedCidrs = value
    }

    @JvmName("tovybsvjwtbiiket")
    public suspend fun disallowedCidrs(vararg values: Output<String>) {
        this.disallowedCidrs = Output.all(values.asList())
    }

    /**
     * @param values Exclude a particular CIDR range from being returned by the pool.
     */
    @JvmName("ggmxdrsxkdyqhsah")
    public suspend fun disallowedCidrs(values: List<Output<String>>) {
        this.disallowedCidrs = Output.all(values)
    }

    /**
     * @param value The ID of the pool to which you want to assign a CIDR.
     */
    @JvmName("jdfsrhhelcsswbds")
    public suspend fun ipamPoolId(`value`: Output<String>) {
        this.ipamPoolId = value
    }

    /**
     * @param value The netmask length of the CIDR you would like to preview from the IPAM pool.
     */
    @JvmName("elhbevvxqmaggfsn")
    public suspend fun netmaskLength(`value`: Output<Int>) {
        this.netmaskLength = value
    }

    /**
     * @param value Exclude a particular CIDR range from being returned by the pool.
     */
    @JvmName("wijnaeqlcigceafd")
    public suspend fun disallowedCidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disallowedCidrs = mapped
    }

    /**
     * @param values Exclude a particular CIDR range from being returned by the pool.
     */
    @JvmName("kwgnvmisownfwhvn")
    public suspend fun disallowedCidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disallowedCidrs = mapped
    }

    /**
     * @param value The ID of the pool to which you want to assign a CIDR.
     */
    @JvmName("eulgopxpvtnprdaa")
    public suspend fun ipamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipamPoolId = mapped
    }

    /**
     * @param value The netmask length of the CIDR you would like to preview from the IPAM pool.
     */
    @JvmName("hbcfpoueivylleyp")
    public suspend fun netmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netmaskLength = mapped
    }

    internal fun build(): VpcIpamPreviewNextCidrArgs = VpcIpamPreviewNextCidrArgs(
        disallowedCidrs = disallowedCidrs,
        ipamPoolId = ipamPoolId,
        netmaskLength = netmaskLength,
    )
}
