@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.VpcIpamResourceDiscoveryOperatingRegion
import com.pulumi.aws.ec2.kotlin.outputs.VpcIpamResourceDiscoveryOperatingRegion.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcIpamResourceDiscovery].
 */
@PulumiTagMarker
public class VpcIpamResourceDiscoveryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamResourceDiscoveryArgs = VpcIpamResourceDiscoveryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamResourceDiscoveryArgsBuilder.() -> Unit) {
        val builder = VpcIpamResourceDiscoveryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcIpamResourceDiscovery {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpamResourceDiscovery(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpamResourceDiscovery(builtJavaResource)
    }
}

/**
 * Provides an IPAM Resource Discovery resource. IPAM Resource Discoveries are resources meant for multi-organization customers. If you wish to use a single IPAM across multiple orgs, a resource discovery can be created and shared from a subordinate organization to the management organizations IPAM delegated admin account. For a full deployment example, see `aws.ec2.VpcIpamResourceDiscoveryAssociation` resource.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscovery;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamResourceDiscoveryOperatingRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var main = new VpcIpamResourceDiscovery("main", VpcIpamResourceDiscoveryArgs.builder()
 *             .description("My IPAM Resource Discovery")
 *             .operatingRegions(VpcIpamResourceDiscoveryOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .tags(Map.of("Test", "Main"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IPAMs using the IPAM resource discovery `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpamResourceDiscovery:VpcIpamResourceDiscovery example ipam-res-disco-0178368ad2146a492
 * ```
 *
 */
public class VpcIpamResourceDiscovery internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpamResourceDiscovery,
) : KotlinCustomResource(javaResource, VpcIpamResourceDiscoveryMapper) {
    /**
     * Amazon Resource Name (ARN) of IPAM Resource Discovery
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description for the IPAM Resource Discovery.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The home region of the Resource Discovery
     */
    public val ipamResourceDiscoveryRegion: Output<String>
        get() = javaResource.ipamResourceDiscoveryRegion().applyValue({ args0 -> args0 })

    /**
     * A boolean to identify if the Resource Discovery is the accounts default resource discovery
     */
    public val isDefault: Output<Boolean>
        get() = javaResource.isDefault().applyValue({ args0 -> args0 })

    /**
     * Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    public val operatingRegions: Output<List<VpcIpamResourceDiscoveryOperatingRegion>>
        get() = javaResource.operatingRegions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The account ID for the account that manages the Resource Discovery
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VpcIpamResourceDiscoveryMapper : ResourceMapper<VpcIpamResourceDiscovery> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpamResourceDiscovery::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpamResourceDiscovery =
        VpcIpamResourceDiscovery(javaResource as com.pulumi.aws.ec2.VpcIpamResourceDiscovery)
}

/**
 * @see [VpcIpamResourceDiscovery].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpamResourceDiscovery].
 */
public suspend fun vpcIpamResourceDiscovery(
    name: String,
    block: suspend VpcIpamResourceDiscoveryResourceBuilder.() -> Unit,
): VpcIpamResourceDiscovery {
    val builder = VpcIpamResourceDiscoveryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpamResourceDiscovery].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpamResourceDiscovery(name: String): VpcIpamResourceDiscovery {
    val builder = VpcIpamResourceDiscoveryResourceBuilder()
    builder.name(name)
    return builder.build()
}
