@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.VpcIpamResourceDiscoveryOperatingRegionArgs
import com.pulumi.aws.ec2.kotlin.inputs.VpcIpamResourceDiscoveryOperatingRegionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IPAM Resource Discovery resource. IPAM Resource Discoveries are resources meant for multi-organization customers. If you wish to use a single IPAM across multiple orgs, a resource discovery can be created and shared from a subordinate organization to the management organizations IPAM delegated admin account. For a full deployment example, see `aws.ec2.VpcIpamResourceDiscoveryAssociation` resource.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscovery;
 * import com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamResourceDiscoveryOperatingRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var main = new VpcIpamResourceDiscovery("main", VpcIpamResourceDiscoveryArgs.builder()
 *             .description("My IPAM Resource Discovery")
 *             .operatingRegions(VpcIpamResourceDiscoveryOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .tags(Map.of("Test", "Main"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IPAMs using the IPAM resource discovery `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpamResourceDiscovery:VpcIpamResourceDiscovery example ipam-res-disco-0178368ad2146a492
 * ```
 * @property description A description for the IPAM Resource Discovery.
 * @property operatingRegions Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class VpcIpamResourceDiscoveryArgs(
    public val description: Output<String>? = null,
    public val operatingRegions: Output<List<VpcIpamResourceDiscoveryOperatingRegionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs =
        com.pulumi.aws.ec2.VpcIpamResourceDiscoveryArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .operatingRegions(
                operatingRegions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VpcIpamResourceDiscoveryArgs].
 */
@PulumiTagMarker
public class VpcIpamResourceDiscoveryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var operatingRegions: Output<List<VpcIpamResourceDiscoveryOperatingRegionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description for the IPAM Resource Discovery.
     */
    @JvmName("gccoypiinbcybacj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("dpphqritynyjxwmu")
    public suspend
    fun operatingRegions(`value`: Output<List<VpcIpamResourceDiscoveryOperatingRegionArgs>>) {
        this.operatingRegions = value
    }

    @JvmName("eirmhteqecmlinwm")
    public suspend fun operatingRegions(
        vararg
        values: Output<VpcIpamResourceDiscoveryOperatingRegionArgs>,
    ) {
        this.operatingRegions = Output.all(values.asList())
    }

    /**
     * @param values Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("udwbepnsorbceuah")
    public suspend
    fun operatingRegions(values: List<Output<VpcIpamResourceDiscoveryOperatingRegionArgs>>) {
        this.operatingRegions = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("luqvhrrsuelrqmkl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description for the IPAM Resource Discovery.
     */
    @JvmName("ahnlentcrcfjhtfa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("bpkbbjmjqavkbrye")
    public suspend fun operatingRegions(`value`: List<VpcIpamResourceDiscoveryOperatingRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingRegions = mapped
    }

    /**
     * @param argument Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("rngolrfwjsgtmmoe")
    public suspend
    fun operatingRegions(argument: List<suspend VpcIpamResourceDiscoveryOperatingRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpcIpamResourceDiscoveryOperatingRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.operatingRegions = mapped
    }

    /**
     * @param argument Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("lsgjjiprcewwaeua")
    public suspend fun operatingRegions(
        vararg
        argument: suspend VpcIpamResourceDiscoveryOperatingRegionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpcIpamResourceDiscoveryOperatingRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.operatingRegions = mapped
    }

    /**
     * @param argument Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("gepvwnqqsiteacgk")
    public suspend
    fun operatingRegions(argument: suspend VpcIpamResourceDiscoveryOperatingRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpcIpamResourceDiscoveryOperatingRegionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.operatingRegions = mapped
    }

    /**
     * @param values Determines which regions the Resource Discovery will enable IPAM features for usage and monitoring. Locale is the Region where you want to make an IPAM pool available for allocations. You can only create pools with locales that match the operating Regions of the IPAM Resource Discovery. You can only create VPCs from a pool whose locale matches the VPC's Region. You specify a region using the region_name parameter. **You must set your provider block region as an operating_region.**
     */
    @JvmName("tlmgvumxupqlmqes")
    public suspend fun operatingRegions(vararg values: VpcIpamResourceDiscoveryOperatingRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operatingRegions = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ktvxxybfllsbymwa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("amkogybvbnajjibe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): VpcIpamResourceDiscoveryArgs = VpcIpamResourceDiscoveryArgs(
        description = description,
        operatingRegions = operatingRegions,
        tags = tags,
    )
}
