@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VpcIpamScope].
 */
@PulumiTagMarker
public class VpcIpamScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpamScopeArgs = VpcIpamScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpamScopeArgsBuilder.() -> Unit) {
        val builder = VpcIpamScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcIpamScope {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpamScope(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpamScope(builtJavaResource)
    }
}

/**
 * Creates a scope for AWS IPAM.
 * ## Example Usage
 * Basic usage:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpam;
 * import com.pulumi.aws.ec2.VpcIpamArgs;
 * import com.pulumi.aws.ec2.inputs.VpcIpamOperatingRegionArgs;
 * import com.pulumi.aws.ec2.VpcIpamScope;
 * import com.pulumi.aws.ec2.VpcIpamScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleVpcIpam = new VpcIpam("exampleVpcIpam", VpcIpamArgs.builder()
 *             .operatingRegions(VpcIpamOperatingRegionArgs.builder()
 *                 .regionName(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .build())
 *             .build());
 *         var exampleVpcIpamScope = new VpcIpamScope("exampleVpcIpamScope", VpcIpamScopeArgs.builder()
 *             .ipamId(exampleVpcIpam.id())
 *             .description("Another Scope")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import IPAMs using the `scope_id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpamScope:VpcIpamScope example ipam-scope-0513c69f283d11dfb
 * ```
 *
 */
public class VpcIpamScope internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpamScope,
) : KotlinCustomResource(javaResource, VpcIpamScopeMapper) {
    /**
     * The Amazon Resource Name (ARN) of the scope.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description for the scope you're creating.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the IPAM for which you're creating this scope.
     */
    public val ipamArn: Output<String>
        get() = javaResource.ipamArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the IPAM for which you're creating this scope.
     */
    public val ipamId: Output<String>
        get() = javaResource.ipamId().applyValue({ args0 -> args0 })

    public val ipamScopeType: Output<String>
        get() = javaResource.ipamScopeType().applyValue({ args0 -> args0 })

    /**
     * Defines if the scope is the default scope or not.
     */
    public val isDefault: Output<Boolean>
        get() = javaResource.isDefault().applyValue({ args0 -> args0 })

    /**
     * The number of pools in the scope.
     */
    public val poolCount: Output<Int>
        get() = javaResource.poolCount().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object VpcIpamScopeMapper : ResourceMapper<VpcIpamScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpamScope::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpamScope = VpcIpamScope(
        javaResource as
            com.pulumi.aws.ec2.VpcIpamScope,
    )
}

/**
 * @see [VpcIpamScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpamScope].
 */
public suspend fun vpcIpamScope(
    name: String,
    block: suspend VpcIpamScopeResourceBuilder.() -> Unit,
): VpcIpamScope {
    val builder = VpcIpamScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpamScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpamScope(name: String): VpcIpamScope {
    val builder = VpcIpamScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
