@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcIpv4CidrBlockAssociation].
 */
@PulumiTagMarker
public class VpcIpv4CidrBlockAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpv4CidrBlockAssociationArgs = VpcIpv4CidrBlockAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpv4CidrBlockAssociationArgsBuilder.() -> Unit) {
        val builder = VpcIpv4CidrBlockAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcIpv4CidrBlockAssociation {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpv4CidrBlockAssociation(builtJavaResource)
    }
}

/**
 * Provides a resource to associate additional IPv4 CIDR blocks with a VPC.
 * When a VPC is created, a primary IPv4 CIDR block for the VPC must be specified.
 * The `aws.ec2.VpcIpv4CidrBlockAssociation` resource allows further IPv4 CIDR blocks to be added to the VPC.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociation;
 * import com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var secondaryCidr = new VpcIpv4CidrBlockAssociation("secondaryCidr", VpcIpv4CidrBlockAssociationArgs.builder()
 *             .vpcId(main.id())
 *             .cidrBlock("172.20.0.0/16")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_vpc_ipv4_cidr_block_association` using the VPC CIDR Association ID. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpv4CidrBlockAssociation:VpcIpv4CidrBlockAssociation example vpc-cidr-assoc-xxxxxxxx
 * ```
 *
 */
public class VpcIpv4CidrBlockAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociation,
) : KotlinCustomResource(javaResource, VpcIpv4CidrBlockAssociationMapper) {
    /**
     * The IPv4 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv4_netmask_length`.
     */
    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    /**
     * The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
     */
    public val ipv4IpamPoolId: Output<String>?
        get() = javaResource.ipv4IpamPoolId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a `ipv4_ipam_pool_id`.
     */
    public val ipv4NetmaskLength: Output<Int>?
        get() = javaResource.ipv4NetmaskLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the VPC to make the association with.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object VpcIpv4CidrBlockAssociationMapper : ResourceMapper<VpcIpv4CidrBlockAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociation::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpv4CidrBlockAssociation =
        VpcIpv4CidrBlockAssociation(javaResource as com.pulumi.aws.ec2.VpcIpv4CidrBlockAssociation)
}

/**
 * @see [VpcIpv4CidrBlockAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpv4CidrBlockAssociation].
 */
public suspend fun vpcIpv4CidrBlockAssociation(
    name: String,
    block: suspend VpcIpv4CidrBlockAssociationResourceBuilder.() -> Unit,
):
    VpcIpv4CidrBlockAssociation {
    val builder = VpcIpv4CidrBlockAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpv4CidrBlockAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpv4CidrBlockAssociation(name: String): VpcIpv4CidrBlockAssociation {
    val builder = VpcIpv4CidrBlockAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
