@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcIpv6CidrBlockAssociation].
 */
@PulumiTagMarker
public class VpcIpv6CidrBlockAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcIpv6CidrBlockAssociationArgs = VpcIpv6CidrBlockAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcIpv6CidrBlockAssociationArgsBuilder.() -> Unit) {
        val builder = VpcIpv6CidrBlockAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcIpv6CidrBlockAssociation {
        val builtJavaResource = com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcIpv6CidrBlockAssociation(builtJavaResource)
    }
}

/**
 * Provides a resource to associate additional IPv6 CIDR blocks with a VPC.
 * The `aws.ec2.VpcIpv6CidrBlockAssociation` resource allows IPv6 CIDR blocks to be added to the VPC.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociation;
 * import com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testVpc = new Vpc("testVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var testVpcIpv6CidrBlockAssociation = new VpcIpv6CidrBlockAssociation("testVpcIpv6CidrBlockAssociation", VpcIpv6CidrBlockAssociationArgs.builder()
 *             .ipv6IpamPoolId(aws_vpc_ipam_pool.test().id())
 *             .vpcId(testVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_vpc_ipv6_cidr_block_association` using the VPC CIDR Association ID. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpv6CidrBlockAssociation:VpcIpv6CidrBlockAssociation example vpc-cidr-assoc-xxxxxxxx
 * ```
 *
 */
public class VpcIpv6CidrBlockAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociation,
) : KotlinCustomResource(javaResource, VpcIpv6CidrBlockAssociationMapper) {
    /**
     * The IPv6 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv6_netmask_length`. This parameter is required if `ipv6_netmask_length` is not set and the IPAM pool does not have `allocation_default_netmask` set.
     */
    public val ipv6CidrBlock: Output<String>
        get() = javaResource.ipv6CidrBlock().applyValue({ args0 -> args0 })

    /**
     * The ID of an IPv6 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts.
     */
    public val ipv6IpamPoolId: Output<String>
        get() = javaResource.ipv6IpamPoolId().applyValue({ args0 -> args0 })

    /**
     * The netmask length of the IPv6 CIDR you want to allocate to this VPC. Requires specifying a `ipv6_ipam_pool_id`. This parameter is optional if the IPAM pool has `allocation_default_netmask` set, otherwise it or `cidr_block` are required
     */
    public val ipv6NetmaskLength: Output<Int>?
        get() = javaResource.ipv6NetmaskLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the VPC to make the association with.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object VpcIpv6CidrBlockAssociationMapper : ResourceMapper<VpcIpv6CidrBlockAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociation::class == javaResource::class

    override fun map(javaResource: Resource): VpcIpv6CidrBlockAssociation =
        VpcIpv6CidrBlockAssociation(javaResource as com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociation)
}

/**
 * @see [VpcIpv6CidrBlockAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcIpv6CidrBlockAssociation].
 */
public suspend fun vpcIpv6CidrBlockAssociation(
    name: String,
    block: suspend VpcIpv6CidrBlockAssociationResourceBuilder.() -> Unit,
):
    VpcIpv6CidrBlockAssociation {
    val builder = VpcIpv6CidrBlockAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcIpv6CidrBlockAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcIpv6CidrBlockAssociation(name: String): VpcIpv6CidrBlockAssociation {
    val builder = VpcIpv6CidrBlockAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
