@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to associate additional IPv6 CIDR blocks with a VPC.
 * The `aws.ec2.VpcIpv6CidrBlockAssociation` resource allows IPv6 CIDR blocks to be added to the VPC.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociation;
 * import com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testVpc = new Vpc("testVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var testVpcIpv6CidrBlockAssociation = new VpcIpv6CidrBlockAssociation("testVpcIpv6CidrBlockAssociation", VpcIpv6CidrBlockAssociationArgs.builder()
 *             .ipv6IpamPoolId(aws_vpc_ipam_pool.test().id())
 *             .vpcId(testVpc.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_vpc_ipv6_cidr_block_association` using the VPC CIDR Association ID. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcIpv6CidrBlockAssociation:VpcIpv6CidrBlockAssociation example vpc-cidr-assoc-xxxxxxxx
 * ```
 * @property ipv6CidrBlock The IPv6 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv6_netmask_length`. This parameter is required if `ipv6_netmask_length` is not set and the IPAM pool does not have `allocation_default_netmask` set.
 * @property ipv6IpamPoolId The ID of an IPv6 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts.
 * @property ipv6NetmaskLength The netmask length of the IPv6 CIDR you want to allocate to this VPC. Requires specifying a `ipv6_ipam_pool_id`. This parameter is optional if the IPAM pool has `allocation_default_netmask` set, otherwise it or `cidr_block` are required
 * @property vpcId The ID of the VPC to make the association with.
 */
public data class VpcIpv6CidrBlockAssociationArgs(
    public val ipv6CidrBlock: Output<String>? = null,
    public val ipv6IpamPoolId: Output<String>? = null,
    public val ipv6NetmaskLength: Output<Int>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociationArgs =
        com.pulumi.aws.ec2.VpcIpv6CidrBlockAssociationArgs.builder()
            .ipv6CidrBlock(ipv6CidrBlock?.applyValue({ args0 -> args0 }))
            .ipv6IpamPoolId(ipv6IpamPoolId?.applyValue({ args0 -> args0 }))
            .ipv6NetmaskLength(ipv6NetmaskLength?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcIpv6CidrBlockAssociationArgs].
 */
@PulumiTagMarker
public class VpcIpv6CidrBlockAssociationArgsBuilder internal constructor() {
    private var ipv6CidrBlock: Output<String>? = null

    private var ipv6IpamPoolId: Output<String>? = null

    private var ipv6NetmaskLength: Output<Int>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The IPv6 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv6_netmask_length`. This parameter is required if `ipv6_netmask_length` is not set and the IPAM pool does not have `allocation_default_netmask` set.
     */
    @JvmName("ablwkxoaslwqsyjn")
    public suspend fun ipv6CidrBlock(`value`: Output<String>) {
        this.ipv6CidrBlock = value
    }

    /**
     * @param value The ID of an IPv6 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts.
     */
    @JvmName("ljpibrjhbmsomxwj")
    public suspend fun ipv6IpamPoolId(`value`: Output<String>) {
        this.ipv6IpamPoolId = value
    }

    /**
     * @param value The netmask length of the IPv6 CIDR you want to allocate to this VPC. Requires specifying a `ipv6_ipam_pool_id`. This parameter is optional if the IPAM pool has `allocation_default_netmask` set, otherwise it or `cidr_block` are required
     */
    @JvmName("xytbdlofqkxkkbon")
    public suspend fun ipv6NetmaskLength(`value`: Output<Int>) {
        this.ipv6NetmaskLength = value
    }

    /**
     * @param value The ID of the VPC to make the association with.
     */
    @JvmName("vvddgquyorfwuoei")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The IPv6 CIDR block for the VPC. CIDR can be explicitly set or it can be derived from IPAM using `ipv6_netmask_length`. This parameter is required if `ipv6_netmask_length` is not set and the IPAM pool does not have `allocation_default_netmask` set.
     */
    @JvmName("advbcochlmjgblpe")
    public suspend fun ipv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlock = mapped
    }

    /**
     * @param value The ID of an IPv6 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts.
     */
    @JvmName("cslmrmkmhwpjodrc")
    public suspend fun ipv6IpamPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6IpamPoolId = mapped
    }

    /**
     * @param value The netmask length of the IPv6 CIDR you want to allocate to this VPC. Requires specifying a `ipv6_ipam_pool_id`. This parameter is optional if the IPAM pool has `allocation_default_netmask` set, otherwise it or `cidr_block` are required
     */
    @JvmName("djnxknfblrqtrann")
    public suspend fun ipv6NetmaskLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6NetmaskLength = mapped
    }

    /**
     * @param value The ID of the VPC to make the association with.
     */
    @JvmName("ebtdhqywfvwjuuyb")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): VpcIpv6CidrBlockAssociationArgs = VpcIpv6CidrBlockAssociationArgs(
        ipv6CidrBlock = ipv6CidrBlock,
        ipv6IpamPoolId = ipv6IpamPoolId,
        ipv6NetmaskLength = ipv6NetmaskLength,
        vpcId = vpcId,
    )
}
