@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpcNetworkPerformanceMetricSubscription].
 */
@PulumiTagMarker
public class VpcNetworkPerformanceMetricSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcNetworkPerformanceMetricSubscriptionArgs =
        VpcNetworkPerformanceMetricSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend VpcNetworkPerformanceMetricSubscriptionArgsBuilder.() -> Unit) {
        val builder = VpcNetworkPerformanceMetricSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcNetworkPerformanceMetricSubscription {
        val builtJavaResource =
            com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VpcNetworkPerformanceMetricSubscription(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an Infrastructure Performance subscription.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscription;
 * import com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcNetworkPerformanceMetricSubscription("example", VpcNetworkPerformanceMetricSubscriptionArgs.builder()
 *             .destination("us-west-1")
 *             .source("us-east-1")
 *             .build());
 *     }
 * }
 * ```
 */
public class VpcNetworkPerformanceMetricSubscription internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscription,
) : KotlinCustomResource(javaResource, VpcNetworkPerformanceMetricSubscriptionMapper) {
    /**
     * The target Region or Availability Zone that the metric subscription is enabled for. For example, `eu-west-1`.
     */
    public val destination: Output<String>
        get() = javaResource.destination().applyValue({ args0 -> args0 })

    /**
     * The metric used for the enabled subscription. Valid values: `aggregate-latency`. Default: `aggregate-latency`.
     */
    public val metric: Output<String>?
        get() = javaResource.metric().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The data aggregation time for the subscription.
     */
    public val period: Output<String>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    /**
     * The source Region or Availability Zone that the metric subscription is enabled for. For example, `us-east-1`.
     */
    public val source: Output<String>
        get() = javaResource.source().applyValue({ args0 -> args0 })

    /**
     * The statistic used for the enabled subscription. Valid values: `p50`. Default: `p50`.
     */
    public val statistic: Output<String>?
        get() = javaResource.statistic().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object VpcNetworkPerformanceMetricSubscriptionMapper :
    ResourceMapper<VpcNetworkPerformanceMetricSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscription::class == javaResource::class

    override fun map(javaResource: Resource): VpcNetworkPerformanceMetricSubscription =
        VpcNetworkPerformanceMetricSubscription(
            javaResource as
                com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscription,
        )
}

/**
 * @see [VpcNetworkPerformanceMetricSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcNetworkPerformanceMetricSubscription].
 */
public suspend fun vpcNetworkPerformanceMetricSubscription(
    name: String,
    block: suspend VpcNetworkPerformanceMetricSubscriptionResourceBuilder.() -> Unit,
):
    VpcNetworkPerformanceMetricSubscription {
    val builder = VpcNetworkPerformanceMetricSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcNetworkPerformanceMetricSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcNetworkPerformanceMetricSubscription(name: String):
    VpcNetworkPerformanceMetricSubscription {
    val builder = VpcNetworkPerformanceMetricSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
