@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an Infrastructure Performance subscription.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscription;
 * import com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcNetworkPerformanceMetricSubscription("example", VpcNetworkPerformanceMetricSubscriptionArgs.builder()
 *             .destination("us-west-1")
 *             .source("us-east-1")
 *             .build());
 *     }
 * }
 * ```
 * @property destination The target Region or Availability Zone that the metric subscription is enabled for. For example, `eu-west-1`.
 * @property metric The metric used for the enabled subscription. Valid values: `aggregate-latency`. Default: `aggregate-latency`.
 * @property source The source Region or Availability Zone that the metric subscription is enabled for. For example, `us-east-1`.
 * @property statistic The statistic used for the enabled subscription. Valid values: `p50`. Default: `p50`.
 */
public data class VpcNetworkPerformanceMetricSubscriptionArgs(
    public val destination: Output<String>? = null,
    public val metric: Output<String>? = null,
    public val source: Output<String>? = null,
    public val statistic: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscriptionArgs =
        com.pulumi.aws.ec2.VpcNetworkPerformanceMetricSubscriptionArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0 }))
            .metric(metric?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .statistic(statistic?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcNetworkPerformanceMetricSubscriptionArgs].
 */
@PulumiTagMarker
public class VpcNetworkPerformanceMetricSubscriptionArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var metric: Output<String>? = null

    private var source: Output<String>? = null

    private var statistic: Output<String>? = null

    /**
     * @param value The target Region or Availability Zone that the metric subscription is enabled for. For example, `eu-west-1`.
     */
    @JvmName("dwxkewbeceoplqew")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value The metric used for the enabled subscription. Valid values: `aggregate-latency`. Default: `aggregate-latency`.
     */
    @JvmName("rvveinrbqrnplsbv")
    public suspend fun metric(`value`: Output<String>) {
        this.metric = value
    }

    /**
     * @param value The source Region or Availability Zone that the metric subscription is enabled for. For example, `us-east-1`.
     */
    @JvmName("fadocclexyomjcfr")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The statistic used for the enabled subscription. Valid values: `p50`. Default: `p50`.
     */
    @JvmName("jvwiefnvsvjrysfp")
    public suspend fun statistic(`value`: Output<String>) {
        this.statistic = value
    }

    /**
     * @param value The target Region or Availability Zone that the metric subscription is enabled for. For example, `eu-west-1`.
     */
    @JvmName("avyqxibylntrkflb")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value The metric used for the enabled subscription. Valid values: `aggregate-latency`. Default: `aggregate-latency`.
     */
    @JvmName("grfioeviauvhjsnd")
    public suspend fun metric(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metric = mapped
    }

    /**
     * @param value The source Region or Availability Zone that the metric subscription is enabled for. For example, `us-east-1`.
     */
    @JvmName("mgrlyebkjpiwebbw")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The statistic used for the enabled subscription. Valid values: `p50`. Default: `p50`.
     */
    @JvmName("evshgwbjfmupsewt")
    public suspend fun statistic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statistic = mapped
    }

    internal fun build(): VpcNetworkPerformanceMetricSubscriptionArgs =
        VpcNetworkPerformanceMetricSubscriptionArgs(
            destination = destination,
            metric = metric,
            source = source,
            statistic = statistic,
        )
}
