@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.VpcPeeringConnectionAccepter
import com.pulumi.aws.ec2.kotlin.outputs.VpcPeeringConnectionRequester
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.VpcPeeringConnectionAccepter.Companion.toKotlin as vpcPeeringConnectionAccepterToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.VpcPeeringConnectionRequester.Companion.toKotlin as vpcPeeringConnectionRequesterToKotlin

/**
 * Builder for [VpcPeeringConnection].
 */
@PulumiTagMarker
public class VpcPeeringConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcPeeringConnectionArgs = VpcPeeringConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcPeeringConnectionArgsBuilder.() -> Unit) {
        val builder = VpcPeeringConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcPeeringConnection {
        val builtJavaResource = com.pulumi.aws.ec2.VpcPeeringConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcPeeringConnection(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a VPC peering connection.
 * > **NOTE on VPC Peering Connections and VPC Peering Connection Options:** This provider provides
 * both a standalone VPC Peering Connection Options and a VPC Peering Connection
 * resource with `accepter` and `requester` attributes. Do not manage options for the same VPC peering
 * connection in both a VPC Peering Connection resource and a VPC Peering Connection Options resource.
 * Doing so will cause a conflict of options and will overwrite the options.
 * Using a VPC Peering Connection Options resource decouples management of the connection options from
 * management of the VPC Peering Connection and allows options to be set correctly in cross-account scenarios.
 * > **Note:** For cross-account (requester's AWS account differs from the accepter's AWS account) or inter-region
 * VPC Peering Connections use the `aws.ec2.VpcPeeringConnection` resource to manage the requester's side of the
 * connection and use the `aws.ec2.VpcPeeringConnectionAccepter` resource to manage the accepter's side of the connection.
 * > **Note:** Creating multiple `aws.ec2.VpcPeeringConnection` resources with the same `peer_vpc_id` and `vpc_id` will not produce an error. Instead, AWS will return the connection `id` that already exists, resulting in multiple `aws.ec2.VpcPeeringConnection` resources with the same `id`.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcPeeringConnection;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new VpcPeeringConnection("foo", VpcPeeringConnectionArgs.builder()
 *             .peerOwnerId(var_.peer_owner_id())
 *             .peerVpcId(aws_vpc.bar().id())
 *             .vpcId(aws_vpc.foo().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Notes
 * If both VPCs are not in the same AWS account and region do not enable the `auto_accept` attribute.
 * The accepter can manage its side of the connection using the `aws.ec2.VpcPeeringConnectionAccepter` resource
 * or accept the connection manually using the AWS Management Console, AWS CLI, through SDKs, etc.
 * ## Import
 * Using `pulumi import`, import VPC Peering resources using the VPC peering `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcPeeringConnection:VpcPeeringConnection test_connection pcx-111aaa111
 * ```
 *
 */
public class VpcPeeringConnection internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcPeeringConnection,
) : KotlinCustomResource(javaResource, VpcPeeringConnectionMapper) {
    /**
     * The status of the VPC Peering Connection request.
     */
    public val acceptStatus: Output<String>
        get() = javaResource.acceptStatus().applyValue({ args0 -> args0 })

    /**
     * An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that accepts
     * the peering connection (a maximum of one).
     */
    public val accepter: Output<VpcPeeringConnectionAccepter>
        get() = javaResource.accepter().applyValue({ args0 ->
            args0.let({ args0 ->
                vpcPeeringConnectionAccepterToKotlin(args0)
            })
        })

    /**
     * Accept the peering (both VPCs need to be in the same AWS account and region).
     */
    public val autoAccept: Output<Boolean>?
        get() = javaResource.autoAccept().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The AWS account ID of the owner of the peer VPC.
     * Defaults to the account ID the AWS provider is currently connected to.
     */
    public val peerOwnerId: Output<String>
        get() = javaResource.peerOwnerId().applyValue({ args0 -> args0 })

    /**
     * The region of the accepter VPC of the VPC Peering Connection. `auto_accept` must be `false`,
     * and use the `aws.ec2.VpcPeeringConnectionAccepter` to manage the accepter side.
     */
    public val peerRegion: Output<String>
        get() = javaResource.peerRegion().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPC with which you are creating the VPC Peering Connection.
     */
    public val peerVpcId: Output<String>
        get() = javaResource.peerVpcId().applyValue({ args0 -> args0 })

    /**
     * A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requests
     * the peering connection (a maximum of one).
     */
    public val requester: Output<VpcPeeringConnectionRequester>
        get() = javaResource.requester().applyValue({ args0 ->
            args0.let({ args0 ->
                vpcPeeringConnectionRequesterToKotlin(args0)
            })
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the requester VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object VpcPeeringConnectionMapper : ResourceMapper<VpcPeeringConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcPeeringConnection::class == javaResource::class

    override fun map(javaResource: Resource): VpcPeeringConnection = VpcPeeringConnection(
        javaResource
            as com.pulumi.aws.ec2.VpcPeeringConnection,
    )
}

/**
 * @see [VpcPeeringConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcPeeringConnection].
 */
public suspend fun vpcPeeringConnection(
    name: String,
    block: suspend VpcPeeringConnectionResourceBuilder.() -> Unit,
): VpcPeeringConnection {
    val builder = VpcPeeringConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcPeeringConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcPeeringConnection(name: String): VpcPeeringConnection {
    val builder = VpcPeeringConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
