@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.VpcPeeringConnectionAccepterAccepter
import com.pulumi.aws.ec2.kotlin.outputs.VpcPeeringConnectionAccepterRequester
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.VpcPeeringConnectionAccepterAccepter.Companion.toKotlin as vpcPeeringConnectionAccepterAccepterToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.VpcPeeringConnectionAccepterRequester.Companion.toKotlin as vpcPeeringConnectionAccepterRequesterToKotlin

/**
 * Builder for [VpcPeeringConnectionAccepter].
 */
@PulumiTagMarker
public class VpcPeeringConnectionAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcPeeringConnectionAccepterArgs = VpcPeeringConnectionAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcPeeringConnectionAccepterArgsBuilder.() -> Unit) {
        val builder = VpcPeeringConnectionAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpcPeeringConnectionAccepter {
        val builtJavaResource = com.pulumi.aws.ec2.VpcPeeringConnectionAccepter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcPeeringConnectionAccepter(builtJavaResource)
    }
}

/**
 * Provides a resource to manage the accepter's side of a VPC Peering Connection.
 * When a cross-account (requester's AWS account differs from the accepter's AWS account) or an inter-region
 * VPC Peering Connection is created, a VPC Peering Connection resource is automatically created in the
 * accepter's account.
 * The requester can use the `aws.ec2.VpcPeeringConnection` resource to manage its side of the connection
 * and the accepter can use the `aws.ec2.VpcPeeringConnectionAccepter` resource to "adopt" its side of the
 * connection into management.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpcPeeringConnection;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionArgs;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionAccepter;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var peer = new Provider("peer", ProviderArgs.builder()
 *             .region("us-west-2")
 *             .build());
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var peerVpc = new Vpc("peerVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.peer())
 *                 .build());
 *         final var peerCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var peerVpcPeeringConnection = new VpcPeeringConnection("peerVpcPeeringConnection", VpcPeeringConnectionArgs.builder()
 *             .vpcId(main.id())
 *             .peerVpcId(peerVpc.id())
 *             .peerOwnerId(peerCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .peerRegion("us-west-2")
 *             .autoAccept(false)
 *             .tags(Map.of("Side", "Requester"))
 *             .build());
 *         var peerVpcPeeringConnectionAccepter = new VpcPeeringConnectionAccepter("peerVpcPeeringConnectionAccepter", VpcPeeringConnectionAccepterArgs.builder()
 *             .vpcPeeringConnectionId(peerVpcPeeringConnection.id())
 *             .autoAccept(true)
 *             .tags(Map.of("Side", "Accepter"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.peer())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Peering Connection Accepters using the Peering Connection ID. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcPeeringConnectionAccepter:VpcPeeringConnectionAccepter example pcx-12345678
 * ```
 *  Certain resource arguments, like `auto_accept`, do not have an EC2 API method for reading the information after peering connection creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 */
public class VpcPeeringConnectionAccepter internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpcPeeringConnectionAccepter,
) : KotlinCustomResource(javaResource, VpcPeeringConnectionAccepterMapper) {
    /**
     * The status of the VPC Peering Connection request.
     */
    public val acceptStatus: Output<String>
        get() = javaResource.acceptStatus().applyValue({ args0 -> args0 })

    /**
     * A configuration block that describes [VPC Peering Connection]
     * (https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options set for the accepter VPC.
     */
    public val accepter: Output<VpcPeeringConnectionAccepterAccepter>
        get() = javaResource.accepter().applyValue({ args0 ->
            args0.let({ args0 ->
                vpcPeeringConnectionAccepterAccepterToKotlin(args0)
            })
        })

    /**
     * Whether or not to accept the peering request. Defaults to `false`.
     */
    public val autoAccept: Output<Boolean>?
        get() = javaResource.autoAccept().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The AWS account ID of the owner of the requester VPC.
     */
    public val peerOwnerId: Output<String>
        get() = javaResource.peerOwnerId().applyValue({ args0 -> args0 })

    /**
     * The region of the accepter VPC.
     */
    public val peerRegion: Output<String>
        get() = javaResource.peerRegion().applyValue({ args0 -> args0 })

    /**
     * The ID of the requester VPC.
     */
    public val peerVpcId: Output<String>
        get() = javaResource.peerVpcId().applyValue({ args0 -> args0 })

    /**
     * A configuration block that describes [VPC Peering Connection]
     * (https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options set for the requester VPC.
     */
    public val requester: Output<VpcPeeringConnectionAccepterRequester>
        get() = javaResource.requester().applyValue({ args0 ->
            args0.let({ args0 ->
                vpcPeeringConnectionAccepterRequesterToKotlin(args0)
            })
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the accepter VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The VPC Peering Connection ID to manage.
     */
    public val vpcPeeringConnectionId: Output<String>
        get() = javaResource.vpcPeeringConnectionId().applyValue({ args0 -> args0 })
}

public object VpcPeeringConnectionAccepterMapper : ResourceMapper<VpcPeeringConnectionAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpcPeeringConnectionAccepter::class == javaResource::class

    override fun map(javaResource: Resource): VpcPeeringConnectionAccepter =
        VpcPeeringConnectionAccepter(javaResource as com.pulumi.aws.ec2.VpcPeeringConnectionAccepter)
}

/**
 * @see [VpcPeeringConnectionAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcPeeringConnectionAccepter].
 */
public suspend fun vpcPeeringConnectionAccepter(
    name: String,
    block: suspend VpcPeeringConnectionAccepterResourceBuilder.() -> Unit,
):
    VpcPeeringConnectionAccepter {
    val builder = VpcPeeringConnectionAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcPeeringConnectionAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcPeeringConnectionAccepter(name: String): VpcPeeringConnectionAccepter {
    val builder = VpcPeeringConnectionAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
