@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcPeeringConnectionAccepterArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.VpcPeeringConnectionAccepterAccepterArgs
import com.pulumi.aws.ec2.kotlin.inputs.VpcPeeringConnectionAccepterAccepterArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.VpcPeeringConnectionAccepterRequesterArgs
import com.pulumi.aws.ec2.kotlin.inputs.VpcPeeringConnectionAccepterRequesterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage the accepter's side of a VPC Peering Connection.
 * When a cross-account (requester's AWS account differs from the accepter's AWS account) or an inter-region
 * VPC Peering Connection is created, a VPC Peering Connection resource is automatically created in the
 * accepter's account.
 * The requester can use the `aws.ec2.VpcPeeringConnection` resource to manage its side of the connection
 * and the accepter can use the `aws.ec2.VpcPeeringConnectionAccepter` resource to "adopt" its side of the
 * connection into management.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.ProviderArgs;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.ec2.VpcPeeringConnection;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionArgs;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionAccepter;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var peer = new Provider("peer", ProviderArgs.builder()
 *             .region("us-west-2")
 *             .build());
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var peerVpc = new Vpc("peerVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.peer())
 *                 .build());
 *         final var peerCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var peerVpcPeeringConnection = new VpcPeeringConnection("peerVpcPeeringConnection", VpcPeeringConnectionArgs.builder()
 *             .vpcId(main.id())
 *             .peerVpcId(peerVpc.id())
 *             .peerOwnerId(peerCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .peerRegion("us-west-2")
 *             .autoAccept(false)
 *             .tags(Map.of("Side", "Requester"))
 *             .build());
 *         var peerVpcPeeringConnectionAccepter = new VpcPeeringConnectionAccepter("peerVpcPeeringConnectionAccepter", VpcPeeringConnectionAccepterArgs.builder()
 *             .vpcPeeringConnectionId(peerVpcPeeringConnection.id())
 *             .autoAccept(true)
 *             .tags(Map.of("Side", "Accepter"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.peer())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Peering Connection Accepters using the Peering Connection ID. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcPeeringConnectionAccepter:VpcPeeringConnectionAccepter example pcx-12345678
 * ```
 *  Certain resource arguments, like `auto_accept`, do not have an EC2 API method for reading the information after peering connection creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property accepter A configuration block that describes [VPC Peering Connection]
 * (https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options set for the accepter VPC.
 * @property autoAccept Whether or not to accept the peering request. Defaults to `false`.
 * @property requester A configuration block that describes [VPC Peering Connection]
 * (https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options set for the requester VPC.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcPeeringConnectionId The VPC Peering Connection ID to manage.
 */
public data class VpcPeeringConnectionAccepterArgs(
    public val accepter: Output<VpcPeeringConnectionAccepterAccepterArgs>? = null,
    public val autoAccept: Output<Boolean>? = null,
    public val requester: Output<VpcPeeringConnectionAccepterRequesterArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcPeeringConnectionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcPeeringConnectionAccepterArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcPeeringConnectionAccepterArgs =
        com.pulumi.aws.ec2.VpcPeeringConnectionAccepterArgs.builder()
            .accepter(accepter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .autoAccept(autoAccept?.applyValue({ args0 -> args0 }))
            .requester(requester?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcPeeringConnectionId(vpcPeeringConnectionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcPeeringConnectionAccepterArgs].
 */
@PulumiTagMarker
public class VpcPeeringConnectionAccepterArgsBuilder internal constructor() {
    private var accepter: Output<VpcPeeringConnectionAccepterAccepterArgs>? = null

    private var autoAccept: Output<Boolean>? = null

    private var requester: Output<VpcPeeringConnectionAccepterRequesterArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcPeeringConnectionId: Output<String>? = null

    /**
     * @param value A configuration block that describes [VPC Peering Connection]
     * (https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options set for the accepter VPC.
     */
    @JvmName("nauxnwjkevpebico")
    public suspend fun accepter(`value`: Output<VpcPeeringConnectionAccepterAccepterArgs>) {
        this.accepter = value
    }

    /**
     * @param value Whether or not to accept the peering request. Defaults to `false`.
     */
    @JvmName("adxebcusglrfgidb")
    public suspend fun autoAccept(`value`: Output<Boolean>) {
        this.autoAccept = value
    }

    /**
     * @param value A configuration block that describes [VPC Peering Connection]
     * (https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options set for the requester VPC.
     */
    @JvmName("wgjvuyqpmviuptsm")
    public suspend fun requester(`value`: Output<VpcPeeringConnectionAccepterRequesterArgs>) {
        this.requester = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cugrpkjkbaylcqlr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VPC Peering Connection ID to manage.
     */
    @JvmName("ytbldbrntjfohvob")
    public suspend fun vpcPeeringConnectionId(`value`: Output<String>) {
        this.vpcPeeringConnectionId = value
    }

    /**
     * @param value A configuration block that describes [VPC Peering Connection]
     * (https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options set for the accepter VPC.
     */
    @JvmName("mvlkwiqcrugipvyh")
    public suspend fun accepter(`value`: VpcPeeringConnectionAccepterAccepterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accepter = mapped
    }

    /**
     * @param argument A configuration block that describes [VPC Peering Connection]
     * (https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options set for the accepter VPC.
     */
    @JvmName("jdxtuclbxowguegy")
    public suspend
    fun accepter(argument: suspend VpcPeeringConnectionAccepterAccepterArgsBuilder.() -> Unit) {
        val toBeMapped = VpcPeeringConnectionAccepterAccepterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.accepter = mapped
    }

    /**
     * @param value Whether or not to accept the peering request. Defaults to `false`.
     */
    @JvmName("jolnxvntuypnuftd")
    public suspend fun autoAccept(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAccept = mapped
    }

    /**
     * @param value A configuration block that describes [VPC Peering Connection]
     * (https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options set for the requester VPC.
     */
    @JvmName("eyehkvopbmaulhvq")
    public suspend fun requester(`value`: VpcPeeringConnectionAccepterRequesterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requester = mapped
    }

    /**
     * @param argument A configuration block that describes [VPC Peering Connection]
     * (https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options set for the requester VPC.
     */
    @JvmName("mqsuqsuaxlohfqbp")
    public suspend
    fun requester(argument: suspend VpcPeeringConnectionAccepterRequesterArgsBuilder.() -> Unit) {
        val toBeMapped = VpcPeeringConnectionAccepterRequesterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.requester = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xuidfyengfiuaaab")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cecfakymwwruycsd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VPC Peering Connection ID to manage.
     */
    @JvmName("yxblhpmrgwpffgvp")
    public suspend fun vpcPeeringConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcPeeringConnectionId = mapped
    }

    internal fun build(): VpcPeeringConnectionAccepterArgs = VpcPeeringConnectionAccepterArgs(
        accepter = accepter,
        autoAccept = autoAccept,
        requester = requester,
        tags = tags,
        vpcPeeringConnectionId = vpcPeeringConnectionId,
    )
}
