@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpcPeeringConnectionArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.VpcPeeringConnectionAccepterArgs
import com.pulumi.aws.ec2.kotlin.inputs.VpcPeeringConnectionAccepterArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.VpcPeeringConnectionRequesterArgs
import com.pulumi.aws.ec2.kotlin.inputs.VpcPeeringConnectionRequesterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a VPC peering connection.
 * > **NOTE on VPC Peering Connections and VPC Peering Connection Options:** This provider provides
 * both a standalone VPC Peering Connection Options and a VPC Peering Connection
 * resource with `accepter` and `requester` attributes. Do not manage options for the same VPC peering
 * connection in both a VPC Peering Connection resource and a VPC Peering Connection Options resource.
 * Doing so will cause a conflict of options and will overwrite the options.
 * Using a VPC Peering Connection Options resource decouples management of the connection options from
 * management of the VPC Peering Connection and allows options to be set correctly in cross-account scenarios.
 * > **Note:** For cross-account (requester's AWS account differs from the accepter's AWS account) or inter-region
 * VPC Peering Connections use the `aws.ec2.VpcPeeringConnection` resource to manage the requester's side of the
 * connection and use the `aws.ec2.VpcPeeringConnectionAccepter` resource to manage the accepter's side of the connection.
 * > **Note:** Creating multiple `aws.ec2.VpcPeeringConnection` resources with the same `peer_vpc_id` and `vpc_id` will not produce an error. Instead, AWS will return the connection `id` that already exists, resulting in multiple `aws.ec2.VpcPeeringConnection` resources with the same `id`.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.VpcPeeringConnection;
 * import com.pulumi.aws.ec2.VpcPeeringConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new VpcPeeringConnection("foo", VpcPeeringConnectionArgs.builder()
 *             .peerOwnerId(var_.peer_owner_id())
 *             .peerVpcId(aws_vpc.bar().id())
 *             .vpcId(aws_vpc.foo().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Notes
 * If both VPCs are not in the same AWS account and region do not enable the `auto_accept` attribute.
 * The accepter can manage its side of the connection using the `aws.ec2.VpcPeeringConnectionAccepter` resource
 * or accept the connection manually using the AWS Management Console, AWS CLI, through SDKs, etc.
 * ## Import
 * Using `pulumi import`, import VPC Peering resources using the VPC peering `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/vpcPeeringConnection:VpcPeeringConnection test_connection pcx-111aaa111
 * ```
 * @property accepter An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that accepts
 * the peering connection (a maximum of one).
 * @property autoAccept Accept the peering (both VPCs need to be in the same AWS account and region).
 * @property peerOwnerId The AWS account ID of the owner of the peer VPC.
 * Defaults to the account ID the AWS provider is currently connected to.
 * @property peerRegion The region of the accepter VPC of the VPC Peering Connection. `auto_accept` must be `false`,
 * and use the `aws.ec2.VpcPeeringConnectionAccepter` to manage the accepter side.
 * @property peerVpcId The ID of the VPC with which you are creating the VPC Peering Connection.
 * @property requester A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requests
 * the peering connection (a maximum of one).
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcId The ID of the requester VPC.
 */
public data class VpcPeeringConnectionArgs(
    public val accepter: Output<VpcPeeringConnectionAccepterArgs>? = null,
    public val autoAccept: Output<Boolean>? = null,
    public val peerOwnerId: Output<String>? = null,
    public val peerRegion: Output<String>? = null,
    public val peerVpcId: Output<String>? = null,
    public val requester: Output<VpcPeeringConnectionRequesterArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpcPeeringConnectionArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpcPeeringConnectionArgs =
        com.pulumi.aws.ec2.VpcPeeringConnectionArgs.builder()
            .accepter(accepter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .autoAccept(autoAccept?.applyValue({ args0 -> args0 }))
            .peerOwnerId(peerOwnerId?.applyValue({ args0 -> args0 }))
            .peerRegion(peerRegion?.applyValue({ args0 -> args0 }))
            .peerVpcId(peerVpcId?.applyValue({ args0 -> args0 }))
            .requester(requester?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcPeeringConnectionArgs].
 */
@PulumiTagMarker
public class VpcPeeringConnectionArgsBuilder internal constructor() {
    private var accepter: Output<VpcPeeringConnectionAccepterArgs>? = null

    private var autoAccept: Output<Boolean>? = null

    private var peerOwnerId: Output<String>? = null

    private var peerRegion: Output<String>? = null

    private var peerVpcId: Output<String>? = null

    private var requester: Output<VpcPeeringConnectionRequesterArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that accepts
     * the peering connection (a maximum of one).
     */
    @JvmName("sivhsxpiobkrimwc")
    public suspend fun accepter(`value`: Output<VpcPeeringConnectionAccepterArgs>) {
        this.accepter = value
    }

    /**
     * @param value Accept the peering (both VPCs need to be in the same AWS account and region).
     */
    @JvmName("xdidrufmkqoracxu")
    public suspend fun autoAccept(`value`: Output<Boolean>) {
        this.autoAccept = value
    }

    /**
     * @param value The AWS account ID of the owner of the peer VPC.
     * Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("wjphudpvbhipklie")
    public suspend fun peerOwnerId(`value`: Output<String>) {
        this.peerOwnerId = value
    }

    /**
     * @param value The region of the accepter VPC of the VPC Peering Connection. `auto_accept` must be `false`,
     * and use the `aws.ec2.VpcPeeringConnectionAccepter` to manage the accepter side.
     */
    @JvmName("pkhdqexoayviunud")
    public suspend fun peerRegion(`value`: Output<String>) {
        this.peerRegion = value
    }

    /**
     * @param value The ID of the VPC with which you are creating the VPC Peering Connection.
     */
    @JvmName("qkgjbblhjvlbmhry")
    public suspend fun peerVpcId(`value`: Output<String>) {
        this.peerVpcId = value
    }

    /**
     * @param value A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requests
     * the peering connection (a maximum of one).
     */
    @JvmName("snwoggafaenxaeln")
    public suspend fun requester(`value`: Output<VpcPeeringConnectionRequesterArgs>) {
        this.requester = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fqbvbkidkpemnige")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the requester VPC.
     */
    @JvmName("egoxvddabtrjakgr")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that accepts
     * the peering connection (a maximum of one).
     */
    @JvmName("naesksvorvufcryi")
    public suspend fun accepter(`value`: VpcPeeringConnectionAccepterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accepter = mapped
    }

    /**
     * @param argument An optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that accepts
     * the peering connection (a maximum of one).
     */
    @JvmName("esnshkqdurvssxht")
    public suspend
    fun accepter(argument: suspend VpcPeeringConnectionAccepterArgsBuilder.() -> Unit) {
        val toBeMapped = VpcPeeringConnectionAccepterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accepter = mapped
    }

    /**
     * @param value Accept the peering (both VPCs need to be in the same AWS account and region).
     */
    @JvmName("uvlecxpjsmhsfhaa")
    public suspend fun autoAccept(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoAccept = mapped
    }

    /**
     * @param value The AWS account ID of the owner of the peer VPC.
     * Defaults to the account ID the AWS provider is currently connected to.
     */
    @JvmName("bonctelghuxwmplq")
    public suspend fun peerOwnerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerOwnerId = mapped
    }

    /**
     * @param value The region of the accepter VPC of the VPC Peering Connection. `auto_accept` must be `false`,
     * and use the `aws.ec2.VpcPeeringConnectionAccepter` to manage the accepter side.
     */
    @JvmName("ddxvmorrjfijavmd")
    public suspend fun peerRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerRegion = mapped
    }

    /**
     * @param value The ID of the VPC with which you are creating the VPC Peering Connection.
     */
    @JvmName("bipodlosgxkjiirf")
    public suspend fun peerVpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerVpcId = mapped
    }

    /**
     * @param value A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requests
     * the peering connection (a maximum of one).
     */
    @JvmName("gbrgroknvwvsklax")
    public suspend fun requester(`value`: VpcPeeringConnectionRequesterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requester = mapped
    }

    /**
     * @param argument A optional configuration block that allows for [VPC Peering Connection](https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html) options to be set for the VPC that requests
     * the peering connection (a maximum of one).
     */
    @JvmName("wtdfttysdgiutuvn")
    public suspend
    fun requester(argument: suspend VpcPeeringConnectionRequesterArgsBuilder.() -> Unit) {
        val toBeMapped = VpcPeeringConnectionRequesterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requester = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yymrsswrqpaklxgn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ktullncirccdtrps")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the requester VPC.
     */
    @JvmName("chukdjtmxrdqpupt")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): VpcPeeringConnectionArgs = VpcPeeringConnectionArgs(
        accepter = accepter,
        autoAccept = autoAccept,
        peerOwnerId = peerOwnerId,
        peerRegion = peerRegion,
        peerVpcId = peerVpcId,
        requester = requester,
        tags = tags,
        vpcId = vpcId,
    )
}
