@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpnConnectionRoute].
 */
@PulumiTagMarker
public class VpnConnectionRouteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpnConnectionRouteArgs = VpnConnectionRouteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpnConnectionRouteArgsBuilder.() -> Unit) {
        val builder = VpnConnectionRouteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpnConnectionRoute {
        val builtJavaResource = com.pulumi.aws.ec2.VpnConnectionRoute(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpnConnectionRoute(builtJavaResource)
    }
}

/**
 * Provides a static route between a VPN connection and a customer gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import com.pulumi.aws.ec2.VpnConnection;
 * import com.pulumi.aws.ec2.VpnConnectionArgs;
 * import com.pulumi.aws.ec2.VpnConnectionRoute;
 * import com.pulumi.aws.ec2.VpnConnectionRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpc = new Vpc("vpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var vpnGateway = new VpnGateway("vpnGateway", VpnGatewayArgs.builder()
 *             .vpcId(vpc.id())
 *             .build());
 *         var customerGateway = new CustomerGateway("customerGateway", CustomerGatewayArgs.builder()
 *             .bgpAsn(65000)
 *             .ipAddress("172.0.0.1")
 *             .type("ipsec.1")
 *             .build());
 *         var main = new VpnConnection("main", VpnConnectionArgs.builder()
 *             .vpnGatewayId(vpnGateway.id())
 *             .customerGatewayId(customerGateway.id())
 *             .type("ipsec.1")
 *             .staticRoutesOnly(true)
 *             .build());
 *         var office = new VpnConnectionRoute("office", VpnConnectionRouteArgs.builder()
 *             .destinationCidrBlock("192.168.10.0/24")
 *             .vpnConnectionId(main.id())
 *             .build());
 *     }
 * }
 * ```
 */
public class VpnConnectionRoute internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpnConnectionRoute,
) : KotlinCustomResource(javaResource, VpnConnectionRouteMapper) {
    /**
     * The CIDR block associated with the local subnet of the customer network.
     */
    public val destinationCidrBlock: Output<String>
        get() = javaResource.destinationCidrBlock().applyValue({ args0 -> args0 })

    /**
     * The ID of the VPN connection.
     */
    public val vpnConnectionId: Output<String>
        get() = javaResource.vpnConnectionId().applyValue({ args0 -> args0 })
}

public object VpnConnectionRouteMapper : ResourceMapper<VpnConnectionRoute> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpnConnectionRoute::class == javaResource::class

    override fun map(javaResource: Resource): VpnConnectionRoute = VpnConnectionRoute(
        javaResource as
            com.pulumi.aws.ec2.VpnConnectionRoute,
    )
}

/**
 * @see [VpnConnectionRoute].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpnConnectionRoute].
 */
public suspend fun vpnConnectionRoute(
    name: String,
    block: suspend VpnConnectionRouteResourceBuilder.() -> Unit,
): VpnConnectionRoute {
    val builder = VpnConnectionRouteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpnConnectionRoute].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpnConnectionRoute(name: String): VpnConnectionRoute {
    val builder = VpnConnectionRouteResourceBuilder()
    builder.name(name)
    return builder.build()
}
