@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpnConnectionRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a static route between a VPN connection and a customer gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import com.pulumi.aws.ec2.VpnConnection;
 * import com.pulumi.aws.ec2.VpnConnectionArgs;
 * import com.pulumi.aws.ec2.VpnConnectionRoute;
 * import com.pulumi.aws.ec2.VpnConnectionRouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpc = new Vpc("vpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var vpnGateway = new VpnGateway("vpnGateway", VpnGatewayArgs.builder()
 *             .vpcId(vpc.id())
 *             .build());
 *         var customerGateway = new CustomerGateway("customerGateway", CustomerGatewayArgs.builder()
 *             .bgpAsn(65000)
 *             .ipAddress("172.0.0.1")
 *             .type("ipsec.1")
 *             .build());
 *         var main = new VpnConnection("main", VpnConnectionArgs.builder()
 *             .vpnGatewayId(vpnGateway.id())
 *             .customerGatewayId(customerGateway.id())
 *             .type("ipsec.1")
 *             .staticRoutesOnly(true)
 *             .build());
 *         var office = new VpnConnectionRoute("office", VpnConnectionRouteArgs.builder()
 *             .destinationCidrBlock("192.168.10.0/24")
 *             .vpnConnectionId(main.id())
 *             .build());
 *     }
 * }
 * ```
 * @property destinationCidrBlock The CIDR block associated with the local subnet of the customer network.
 * @property vpnConnectionId The ID of the VPN connection.
 */
public data class VpnConnectionRouteArgs(
    public val destinationCidrBlock: Output<String>? = null,
    public val vpnConnectionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpnConnectionRouteArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpnConnectionRouteArgs =
        com.pulumi.aws.ec2.VpnConnectionRouteArgs.builder()
            .destinationCidrBlock(destinationCidrBlock?.applyValue({ args0 -> args0 }))
            .vpnConnectionId(vpnConnectionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnConnectionRouteArgs].
 */
@PulumiTagMarker
public class VpnConnectionRouteArgsBuilder internal constructor() {
    private var destinationCidrBlock: Output<String>? = null

    private var vpnConnectionId: Output<String>? = null

    /**
     * @param value The CIDR block associated with the local subnet of the customer network.
     */
    @JvmName("ilfxyrdcqpqhtbnf")
    public suspend fun destinationCidrBlock(`value`: Output<String>) {
        this.destinationCidrBlock = value
    }

    /**
     * @param value The ID of the VPN connection.
     */
    @JvmName("lxecjvdaebxqoefs")
    public suspend fun vpnConnectionId(`value`: Output<String>) {
        this.vpnConnectionId = value
    }

    /**
     * @param value The CIDR block associated with the local subnet of the customer network.
     */
    @JvmName("xviwnmbgyitvslao")
    public suspend fun destinationCidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationCidrBlock = mapped
    }

    /**
     * @param value The ID of the VPN connection.
     */
    @JvmName("qlecvxudbotuqnul")
    public suspend fun vpnConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnConnectionId = mapped
    }

    internal fun build(): VpnConnectionRouteArgs = VpnConnectionRouteArgs(
        destinationCidrBlock = destinationCidrBlock,
        vpnConnectionId = vpnConnectionId,
    )
}
