@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VpnGatewayAttachment].
 */
@PulumiTagMarker
public class VpnGatewayAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpnGatewayAttachmentArgs = VpnGatewayAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpnGatewayAttachmentArgsBuilder.() -> Unit) {
        val builder = VpnGatewayAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VpnGatewayAttachment {
        val builtJavaResource = com.pulumi.aws.ec2.VpnGatewayAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpnGatewayAttachment(builtJavaResource)
    }
}

/**
 * Provides a Virtual Private Gateway attachment resource, allowing for an existing
 * hardware VPN gateway to be attached and/or detached from a VPC.
 * > **Note:** The `aws.ec2.VpnGateway`
 * resource can also automatically attach the Virtual Private Gateway it creates
 * to an existing VPC by setting the `vpc_id` attribute accordingly.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import com.pulumi.aws.ec2.VpnGatewayAttachment;
 * import com.pulumi.aws.ec2.VpnGatewayAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var network = new Vpc("network", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var vpn = new VpnGateway("vpn", VpnGatewayArgs.builder()
 *             .tags(Map.of("Name", "example-vpn-gateway"))
 *             .build());
 *         var vpnAttachment = new VpnGatewayAttachment("vpnAttachment", VpnGatewayAttachmentArgs.builder()
 *             .vpcId(network.id())
 *             .vpnGatewayId(vpn.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * You cannot import this resource.
 */
public class VpnGatewayAttachment internal constructor(
    override val javaResource: com.pulumi.aws.ec2.VpnGatewayAttachment,
) : KotlinCustomResource(javaResource, VpnGatewayAttachmentMapper) {
    /**
     * The ID of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Virtual Private Gateway.
     */
    public val vpnGatewayId: Output<String>
        get() = javaResource.vpnGatewayId().applyValue({ args0 -> args0 })
}

public object VpnGatewayAttachmentMapper : ResourceMapper<VpnGatewayAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.VpnGatewayAttachment::class == javaResource::class

    override fun map(javaResource: Resource): VpnGatewayAttachment = VpnGatewayAttachment(
        javaResource
            as com.pulumi.aws.ec2.VpnGatewayAttachment,
    )
}

/**
 * @see [VpnGatewayAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpnGatewayAttachment].
 */
public suspend fun vpnGatewayAttachment(
    name: String,
    block: suspend VpnGatewayAttachmentResourceBuilder.() -> Unit,
): VpnGatewayAttachment {
    val builder = VpnGatewayAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpnGatewayAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpnGatewayAttachment(name: String): VpnGatewayAttachment {
    val builder = VpnGatewayAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
