@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.VpnGatewayAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Virtual Private Gateway attachment resource, allowing for an existing
 * hardware VPN gateway to be attached and/or detached from a VPC.
 * > **Note:** The `aws.ec2.VpnGateway`
 * resource can also automatically attach the Virtual Private Gateway it creates
 * to an existing VPC by setting the `vpc_id` attribute accordingly.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.VpnGateway;
 * import com.pulumi.aws.ec2.VpnGatewayArgs;
 * import com.pulumi.aws.ec2.VpnGatewayAttachment;
 * import com.pulumi.aws.ec2.VpnGatewayAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var network = new Vpc("network", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var vpn = new VpnGateway("vpn", VpnGatewayArgs.builder()
 *             .tags(Map.of("Name", "example-vpn-gateway"))
 *             .build());
 *         var vpnAttachment = new VpnGatewayAttachment("vpnAttachment", VpnGatewayAttachmentArgs.builder()
 *             .vpcId(network.id())
 *             .vpnGatewayId(vpn.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * You cannot import this resource.
 * @property vpcId The ID of the VPC.
 * @property vpnGatewayId The ID of the Virtual Private Gateway.
 */
public data class VpnGatewayAttachmentArgs(
    public val vpcId: Output<String>? = null,
    public val vpnGatewayId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.VpnGatewayAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ec2.VpnGatewayAttachmentArgs =
        com.pulumi.aws.ec2.VpnGatewayAttachmentArgs.builder()
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vpnGatewayId(vpnGatewayId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnGatewayAttachmentArgs].
 */
@PulumiTagMarker
public class VpnGatewayAttachmentArgsBuilder internal constructor() {
    private var vpcId: Output<String>? = null

    private var vpnGatewayId: Output<String>? = null

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("vqtwjqmuhdktyqal")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the Virtual Private Gateway.
     */
    @JvmName("oowifemjbybadcte")
    public suspend fun vpnGatewayId(`value`: Output<String>) {
        this.vpnGatewayId = value
    }

    /**
     * @param value The ID of the VPC.
     */
    @JvmName("vlmuxenhuknpxmlt")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the Virtual Private Gateway.
     */
    @JvmName("xvdjsegpeoxvmroc")
    public suspend fun vpnGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayId = mapped
    }

    internal fun build(): VpnGatewayAttachmentArgs = VpnGatewayAttachmentArgs(
        vpcId = vpcId,
        vpnGatewayId = vpnGatewayId,
    )
}
