@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.AmiCopyEphemeralBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceName Path at which the device is exposed to created instances.
 * @property virtualName Name for the ephemeral device, of the form "ephemeralN" where
 * *N* is a volume number starting from zero.
 */
public data class AmiCopyEphemeralBlockDeviceArgs(
    public val deviceName: Output<String>? = null,
    public val virtualName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.AmiCopyEphemeralBlockDeviceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.AmiCopyEphemeralBlockDeviceArgs =
        com.pulumi.aws.ec2.inputs.AmiCopyEphemeralBlockDeviceArgs.builder()
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .virtualName(virtualName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmiCopyEphemeralBlockDeviceArgs].
 */
@PulumiTagMarker
public class AmiCopyEphemeralBlockDeviceArgsBuilder internal constructor() {
    private var deviceName: Output<String>? = null

    private var virtualName: Output<String>? = null

    /**
     * @param value Path at which the device is exposed to created instances.
     */
    @JvmName("mjqjbeikievquvtg")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Name for the ephemeral device, of the form "ephemeralN" where
     * *N* is a volume number starting from zero.
     */
    @JvmName("mjlxwatwbpcnsfsb")
    public suspend fun virtualName(`value`: Output<String>) {
        this.virtualName = value
    }

    /**
     * @param value Path at which the device is exposed to created instances.
     */
    @JvmName("wkfkqxlulqaatoqo")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Name for the ephemeral device, of the form "ephemeralN" where
     * *N* is a volume number starting from zero.
     */
    @JvmName("biyquukybnsoatkv")
    public suspend fun virtualName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualName = mapped
    }

    internal fun build(): AmiCopyEphemeralBlockDeviceArgs = AmiCopyEphemeralBlockDeviceArgs(
        deviceName = deviceName,
        virtualName = virtualName,
    )
}
