@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin.inputs

import com.pulumi.aws.ec2.inputs.AmiEbsBlockDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deleteOnTermination Boolean controlling whether the EBS volumes created to
 * support each created instance will be deleted once that instance is terminated.
 * @property deviceName Path at which the device is exposed to created instances.
 * @property encrypted Boolean controlling whether the created EBS volumes will be encrypted. Can't be used with `snapshot_id`.
 * @property iops Number of I/O operations per second the
 * created volumes will support.
 * @property outpostArn ARN of the Outpost on which the snapshot is stored.
 * > **Note:** You can specify `encrypted` or `snapshot_id` but not both.
 * @property snapshotId ID of an EBS snapshot that will be used to initialize the created
 * EBS volumes. If set, the `volume_size` attribute must be at least as large as the referenced
 * snapshot.
 * @property throughput Throughput that the EBS volume supports, in MiB/s. Only valid for `volume_type` of `gp3`.
 * @property volumeSize Size of created volumes in GiB.
 * If `snapshot_id` is set and `volume_size` is omitted then the volume will have the same size
 * as the selected snapshot.
 * @property volumeType Type of EBS volume to create. Can be `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1` or `st1` (Default: `standard`).
 */
public data class AmiEbsBlockDeviceArgs(
    public val deleteOnTermination: Output<Boolean>? = null,
    public val deviceName: Output<String>,
    public val encrypted: Output<Boolean>? = null,
    public val iops: Output<Int>? = null,
    public val outpostArn: Output<String>? = null,
    public val snapshotId: Output<String>? = null,
    public val throughput: Output<Int>? = null,
    public val volumeSize: Output<Int>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.inputs.AmiEbsBlockDeviceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.inputs.AmiEbsBlockDeviceArgs =
        com.pulumi.aws.ec2.inputs.AmiEbsBlockDeviceArgs.builder()
            .deleteOnTermination(deleteOnTermination?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .outpostArn(outpostArn?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .throughput(throughput?.applyValue({ args0 -> args0 }))
            .volumeSize(volumeSize?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmiEbsBlockDeviceArgs].
 */
@PulumiTagMarker
public class AmiEbsBlockDeviceArgsBuilder internal constructor() {
    private var deleteOnTermination: Output<Boolean>? = null

    private var deviceName: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var iops: Output<Int>? = null

    private var outpostArn: Output<String>? = null

    private var snapshotId: Output<String>? = null

    private var throughput: Output<Int>? = null

    private var volumeSize: Output<Int>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value Boolean controlling whether the EBS volumes created to
     * support each created instance will be deleted once that instance is terminated.
     */
    @JvmName("eaocusdpjqhyvmgk")
    public suspend fun deleteOnTermination(`value`: Output<Boolean>) {
        this.deleteOnTermination = value
    }

    /**
     * @param value Path at which the device is exposed to created instances.
     */
    @JvmName("dhqpxfbprssnoiwg")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Boolean controlling whether the created EBS volumes will be encrypted. Can't be used with `snapshot_id`.
     */
    @JvmName("jiukytdfvniejxya")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value Number of I/O operations per second the
     * created volumes will support.
     */
    @JvmName("vqlapfjnveifulbm")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value ARN of the Outpost on which the snapshot is stored.
     * > **Note:** You can specify `encrypted` or `snapshot_id` but not both.
     */
    @JvmName("ygppskuvjctajgkd")
    public suspend fun outpostArn(`value`: Output<String>) {
        this.outpostArn = value
    }

    /**
     * @param value ID of an EBS snapshot that will be used to initialize the created
     * EBS volumes. If set, the `volume_size` attribute must be at least as large as the referenced
     * snapshot.
     */
    @JvmName("clokguilhbabsgxe")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value Throughput that the EBS volume supports, in MiB/s. Only valid for `volume_type` of `gp3`.
     */
    @JvmName("ltffiikjhrhkdjah")
    public suspend fun throughput(`value`: Output<Int>) {
        this.throughput = value
    }

    /**
     * @param value Size of created volumes in GiB.
     * If `snapshot_id` is set and `volume_size` is omitted then the volume will have the same size
     * as the selected snapshot.
     */
    @JvmName("eapxssniqvxtknkx")
    public suspend fun volumeSize(`value`: Output<Int>) {
        this.volumeSize = value
    }

    /**
     * @param value Type of EBS volume to create. Can be `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1` or `st1` (Default: `standard`).
     */
    @JvmName("iebmwwykcmeswhht")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value Boolean controlling whether the EBS volumes created to
     * support each created instance will be deleted once that instance is terminated.
     */
    @JvmName("skriffnreqlnygmt")
    public suspend fun deleteOnTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOnTermination = mapped
    }

    /**
     * @param value Path at which the device is exposed to created instances.
     */
    @JvmName("qkhawjqnfeqjorwl")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Boolean controlling whether the created EBS volumes will be encrypted. Can't be used with `snapshot_id`.
     */
    @JvmName("ayflccnywdynjhra")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value Number of I/O operations per second the
     * created volumes will support.
     */
    @JvmName("gtamdyjusrxcukep")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value ARN of the Outpost on which the snapshot is stored.
     * > **Note:** You can specify `encrypted` or `snapshot_id` but not both.
     */
    @JvmName("edmjpdfqgyrhmbfu")
    public suspend fun outpostArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outpostArn = mapped
    }

    /**
     * @param value ID of an EBS snapshot that will be used to initialize the created
     * EBS volumes. If set, the `volume_size` attribute must be at least as large as the referenced
     * snapshot.
     */
    @JvmName("ckohbkfloijtpacg")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value Throughput that the EBS volume supports, in MiB/s. Only valid for `volume_type` of `gp3`.
     */
    @JvmName("pmrsaerjrwxtctqi")
    public suspend fun throughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughput = mapped
    }

    /**
     * @param value Size of created volumes in GiB.
     * If `snapshot_id` is set and `volume_size` is omitted then the volume will have the same size
     * as the selected snapshot.
     */
    @JvmName("avlkaqqhpjrmhqmr")
    public suspend fun volumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSize = mapped
    }

    /**
     * @param value Type of EBS volume to create. Can be `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1` or `st1` (Default: `standard`).
     */
    @JvmName("hjyshbjyyemxxdrx")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): AmiEbsBlockDeviceArgs = AmiEbsBlockDeviceArgs(
        deleteOnTermination = deleteOnTermination,
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        encrypted = encrypted,
        iops = iops,
        outpostArn = outpostArn,
        snapshotId = snapshotId,
        throughput = throughput,
        volumeSize = volumeSize,
        volumeType = volumeType,
    )
}
